/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.comment;

import com.atlassian.stash.comment.AbstractAddCommentRequest;
import com.atlassian.stash.content.DiffFileType;
import com.atlassian.stash.content.DiffSegmentType;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;

public class AddDiffCommentRequest
extends AbstractAddCommentRequest {
    private final DiffFileType fileType;
    private final int line;
    private final DiffSegmentType lineType;

    private AddDiffCommentRequest(Builder builder) {
        super(builder);
        this.fileType = (DiffFileType)((Object)Preconditions.checkNotNull((Object)((Object)builder.fileType), (Object)"fileType"));
        this.line = builder.line;
        this.lineType = (DiffSegmentType)((Object)Preconditions.checkNotNull((Object)((Object)builder.lineType), (Object)"lineType"));
    }

    @Nonnull
    public DiffFileType getFileType() {
        return this.fileType;
    }

    public int getLine() {
        return this.line;
    }

    @Nonnull
    public DiffSegmentType getLineType() {
        return this.lineType;
    }

    public static class Builder
    extends AbstractAddCommentRequest.AbstractBuilder<Builder, AddDiffCommentRequest> {
        private int line = 0;
        private DiffSegmentType lineType;
        private DiffFileType fileType;

        @Override
        @Nonnull
        public AddDiffCommentRequest build() {
            return new AddDiffCommentRequest(this);
        }

        @Nonnull
        public Builder fileType(@Nonnull DiffFileType value) {
            this.fileType = (DiffFileType)((Object)Preconditions.checkNotNull((Object)((Object)value), (Object)"fileType"));
            return this;
        }

        @Nonnull
        public Builder line(int value) {
            Preconditions.checkArgument((this.line >= 0 ? 1 : 0) != 0, (Object)("Line must be >= 0 (Rejected: " + value + ")"));
            this.line = value;
            return this;
        }

        @Nonnull
        public Builder lineType(@Nonnull DiffSegmentType value) {
            this.lineType = (DiffSegmentType)((Object)Preconditions.checkNotNull((Object)((Object)value), (Object)"lineType"));
            return this;
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

