/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.comment;

import com.atlassian.stash.comment.Comment;
import com.atlassian.stash.content.DiffFileType;
import com.atlassian.stash.content.DiffSegmentType;
import com.google.common.base.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface DiffCommentAnchor {
    public static final Predicate<? super DiffCommentAnchor> IS_FILE_COMMENT = new Predicate<DiffCommentAnchor>(){

        public boolean apply(DiffCommentAnchor anchor) {
            return anchor.isFileComment();
        }
    };
    public static final Predicate<? super DiffCommentAnchor> IS_LINE_COMMENT = new Predicate<DiffCommentAnchor>(){

        public boolean apply(DiffCommentAnchor anchor) {
            return anchor.isLineComment();
        }
    };
    public static final int NO_LINE = 0;

    @Nonnull
    public Comment getComment();

    @Nullable
    public DiffFileType getFileType();

    @Nullable
    public String getFromHash();

    public int getLine();

    @Nullable
    public DiffSegmentType getLineType();

    @Nonnull
    public String getPath();

    @Nullable
    public String getSrcPath();

    @Nonnull
    public String getToHash();

    public boolean isFileComment();

    public boolean isLineComment();
}

