/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.content;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;

public class AttributeMap
implements Map<String, Set<String>> {
    public static final AttributeMap EMPTY = new AttributeMap();
    private Map<String, Set<String>> delegate;

    public AttributeMap() {
        this.delegate = Collections.emptyMap();
    }

    @Deprecated
    public AttributeMap(Map<String, Set<String>> map) {
        this.delegate = new HashMap<String, Set<String>>();
        for (Map.Entry<String, Set<String>> entry : map.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            this.delegate.put(entry.getKey(), Collections.unmodifiableSet(entry.getValue()));
        }
        this.delegate = Collections.unmodifiableMap(this.delegate);
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        if (value instanceof String) {
            String strValue = (String)value;
            for (Set<String> attValues : this.delegate.values()) {
                if (!attValues.contains(strValue)) continue;
                return true;
            }
            return false;
        }
        return this.delegate.containsValue(value);
    }

    @Override
    public Set<String> get(Object attributeName) {
        return this.delegate.get(attributeName);
    }

    @Override
    public Set<String> put(String key, Set<String> values) {
        throw new UnsupportedOperationException("AttributeMap is immutable");
    }

    @Override
    public Set<String> remove(Object key) {
        throw new UnsupportedOperationException("AttributeMap is immutable");
    }

    @Override
    public void putAll(Map<? extends String, ? extends Set<String>> map) {
        throw new UnsupportedOperationException("AttributeMap is immutable");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("AttributeMap is immutable");
    }

    @Override
    public Set<String> keySet() {
        return this.delegate.keySet();
    }

    @Override
    public Collection<Set<String>> values() {
        return this.delegate.values();
    }

    @Override
    public Set<Map.Entry<String, Set<String>>> entrySet() {
        return this.delegate.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        return this.delegate.equals(o);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    public static class Builder {
        private final Map<String, Set<String>> delegate = new HashMap<String, Set<String>>();

        @Nonnull
        public Builder add(@Nonnull String attName, String ... values) {
            return this.add(attName, Arrays.asList(values));
        }

        @Nonnull
        public Builder add(@Nonnull String attName, @Nonnull Iterable<String> values) {
            Set<String> attValues = this.delegate.get(attName);
            if (attValues == null) {
                attValues = new HashSet<String>();
                this.delegate.put(attName, attValues);
            }
            for (String attValue : values) {
                attValues.add(attValue);
            }
            return this;
        }

        @Nonnull
        public Builder add(@Nonnull AttributeMap other) {
            for (Map.Entry<String, Set<String>> entry : other.entrySet()) {
                Set<String> attValues = this.delegate.get(entry.getKey());
                if (attValues == null) {
                    attValues = new HashSet<String>();
                    this.delegate.put(entry.getKey(), attValues);
                }
                attValues.addAll((Collection<String>)entry.getValue());
            }
            return this;
        }

        @Nonnull
        public AttributeMap build() {
            return new AttributeMap(this.delegate);
        }
    }
}

