/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.event;

import com.atlassian.stash.event.RepositoryEvent;
import com.atlassian.stash.repository.Repository;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import org.apache.commons.lang.ObjectUtils;

public class AbstractRepositoryModificationEvent
extends RepositoryEvent {
    protected final Repository newValue;
    protected final Repository oldValue;

    public AbstractRepositoryModificationEvent(@Nonnull Object source, @Nonnull Repository repository, @Nonnull Repository oldValue, @Nonnull Repository newValue) {
        super(source, repository);
        this.newValue = (Repository)Preconditions.checkNotNull((Object)newValue, (Object)"newValue");
        this.oldValue = (Repository)Preconditions.checkNotNull((Object)oldValue, (Object)"oldValue");
    }

    @Nonnull
    public Repository getNewValue() {
        return this.newValue;
    }

    @Nonnull
    public Repository getOldValue() {
        return this.oldValue;
    }

    public boolean isNameChanged() {
        return ObjectUtils.notEqual((Object)this.getOldValue().getName(), (Object)this.getNewValue().getName());
    }

    public boolean isOriginChanged() {
        return ObjectUtils.notEqual((Object)this.getOldValue().getOrigin(), (Object)this.getNewValue().getOrigin());
    }

    public boolean isSlugChanged() {
        return ObjectUtils.notEqual((Object)this.getOldValue().getSlug(), (Object)this.getNewValue().getSlug());
    }

    public boolean isStateChanged() {
        return ObjectUtils.notEqual((Object)((Object)this.getOldValue().getState()), (Object)((Object)this.getNewValue().getState()));
    }
}

