/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.repository;

import com.atlassian.stash.repository.Ref;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.util.BuilderSupport;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class RefMetadataRequest {
    private final Ref baseRef;
    private final Set<Ref> refs;
    private final Repository repository;

    private RefMetadataRequest(Ref baseRef, Set<Ref> refs, Repository repository) {
        this.baseRef = baseRef;
        this.refs = refs;
        this.repository = repository;
    }

    @Nullable
    public Ref getBaseRef() {
        return this.baseRef;
    }

    @Nonnull
    public Set<Ref> getRefs() {
        return this.refs;
    }

    @Nonnull
    public Repository getRepository() {
        return this.repository;
    }

    public static class Builder
    extends BuilderSupport {
        private final ImmutableSet.Builder<Ref> refs = ImmutableSet.builder();
        private Ref baseRef;
        private Repository repository;

        public Builder() {
        }

        public Builder(RefMetadataRequest request) {
            this();
            this.baseRef(request.getBaseRef()).refs(request.getRefs()).repository(request.getRepository());
        }

        public RefMetadataRequest build() {
            ImmutableSet refs = this.refs.build();
            Preconditions.checkState((!refs.isEmpty() ? 1 : 0) != 0, (Object)"At least one ref must be specified");
            Preconditions.checkState((this.repository != null ? 1 : 0) != 0, (Object)"A repository is required");
            return new RefMetadataRequest(this.baseRef, (Set)refs, this.repository);
        }

        public Builder baseRef(Ref baseRef) {
            this.baseRef = baseRef;
            return this;
        }

        public Builder refs(Iterable<? extends Ref> values) {
            Builder.addIf(Predicates.notNull(), this.refs, values);
            return this;
        }

        public Builder refs(Ref value, Ref ... values) {
            Builder.addIf(Predicates.notNull(), this.refs, value, values);
            return this;
        }

        public Builder repository(Repository value) {
            this.repository = (Repository)Preconditions.checkNotNull((Object)value, (Object)"repository");
            return this;
        }
    }
}

