/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.scm;

import com.atlassian.stash.content.ChangesetContext;
import com.atlassian.stash.content.ChangesetsBetweenRequest;
import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.scm.AbstractCommandParameters;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nonnull;

public class CommitsCommandParameters
extends AbstractCommandParameters {
    private final boolean all;
    private final Set<String> excludes;
    private final Set<String> includes;
    private final Set<String> paths;
    private final Repository secondaryRepository;
    private final boolean traversing;

    @Deprecated
    protected CommitsCommandParameters(Set<String> includes, Set<String> excludes, Set<String> paths, boolean all, boolean traversing) {
        this(includes, excludes, paths, null, all, traversing);
    }

    private CommitsCommandParameters(Set<String> includes, Set<String> excludes, Set<String> paths, Repository secondaryRepository, boolean all, boolean traversing) {
        this.all = all;
        this.excludes = excludes;
        this.includes = includes;
        this.paths = paths;
        this.secondaryRepository = secondaryRepository;
        this.traversing = traversing;
    }

    @Nonnull
    public Set<String> getExcludes() {
        return this.excludes;
    }

    @Nonnull
    public Set<String> getIncludes() {
        return this.includes;
    }

    @Nonnull
    public Set<String> getPaths() {
        return this.paths;
    }

    @Nonnull
    public Repository getSecondaryRepository() {
        return this.secondaryRepository;
    }

    public boolean isAll() {
        return this.all;
    }

    public boolean isTraversing() {
        return this.traversing;
    }

    public boolean hasExcludes() {
        return !this.excludes.isEmpty();
    }

    public boolean hasIncludes() {
        return !this.includes.isEmpty();
    }

    public boolean hasPaths() {
        return !this.paths.isEmpty();
    }

    public boolean hasSecondaryRepository() {
        return this.secondaryRepository != null;
    }

    @Nonnull
    public ChangesetContext toContext() {
        return new ChangesetContext.Builder().build();
    }

    public static class Builder {
        private final ImmutableSet.Builder<String> excludes = ImmutableSet.builder();
        private final ImmutableSet.Builder<String> includes = ImmutableSet.builder();
        private final ImmutableSet.Builder<String> paths = ImmutableSet.builder();
        private boolean all;
        private Repository secondaryRepository;
        private boolean traversing = true;

        public Builder() {
        }

        public Builder(ChangesetsBetweenRequest request) {
            this();
            this.exclude(request.getExcludes()).include(request.getIncludes()).secondaryRepository(request.getSecondaryRepository()).paths(request.getPaths());
        }

        public Builder all(boolean value) {
            this.all = value;
            return this;
        }

        public CommitsCommandParameters build() {
            ImmutableSet include = this.all ? Collections.emptySet() : this.includes.build();
            ImmutableSet exclude = this.traversing ? this.excludes.build() : Collections.emptySet();
            return new CommitsCommandParameters((Set)include, (Set)exclude, (Set)this.paths.build(), this.secondaryRepository, this.all, this.traversing);
        }

        public Builder exclude(Iterable<String> values) {
            CommitsCommandParameters.addIf(NOT_BLANK, this.excludes, values);
            return this;
        }

        public Builder exclude(String value, String ... values) {
            CommitsCommandParameters.addIf(NOT_BLANK, this.excludes, value, values);
            return this;
        }

        public Builder include(Iterable<String> values) {
            CommitsCommandParameters.addIf(NOT_BLANK, this.includes, values);
            return this;
        }

        public Builder include(String value, String ... values) {
            CommitsCommandParameters.addIf(NOT_BLANK, this.includes, value, values);
            return this;
        }

        public Builder path(String value) {
            CommitsCommandParameters.addIf(NOT_BLANK, this.paths, value);
            return this;
        }

        public Builder paths(Iterable<String> values) {
            CommitsCommandParameters.addIf(NOT_BLANK, this.paths, values);
            return this;
        }

        public Builder paths(String value, String ... values) {
            CommitsCommandParameters.addIf(NOT_BLANK, this.paths, value, values);
            return this;
        }

        public Builder secondaryRepository(Repository value) {
            this.secondaryRepository = value;
            return this;
        }

        public Builder traverse(boolean value) {
            this.traversing = value;
            return this;
        }
    }
}

