/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.util;

import com.atlassian.stash.util.PageRequest;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;

public class PageRequestImpl
implements PageRequest {
    private final int start;
    private final int limit;
    private final String filter;

    public PageRequestImpl(int start, int limit) {
        this(start, limit, null);
    }

    @Deprecated
    public PageRequestImpl(int start, int limit, String filter) {
        this.start = start < 0 ? 0 : start;
        this.limit = limit <= 0 ? 1 : limit;
        this.filter = filter;
        Preconditions.checkArgument((this.limit <= 0x100000 ? 1 : 0) != 0, (Object)"Limit must be less than 1048576");
    }

    @Override
    public int getStart() {
        return this.start;
    }

    @Override
    public int getLimit() {
        return this.limit;
    }

    @Override
    @Deprecated
    public String getFilter() {
        return this.filter;
    }

    public int hashCode() {
        int prime = 31;
        int result = 31 + this.limit;
        result = 31 * result + this.start;
        if (this.filter != null) {
            result = 31 * result + this.filter.hashCode();
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PageRequestImpl other = (PageRequestImpl)obj;
        if (this.limit != other.limit) {
            return false;
        }
        if (this.start != other.start) {
            return false;
        }
        return !(this.filter != null ? !this.filter.equals(other.filter) : other.filter != null);
    }

    @Override
    @Nonnull
    public PageRequest buildRestrictedPageRequest(int maxLimit) {
        return new PageRequestImpl(this.start, Math.min(this.limit, maxLimit), this.filter);
    }
}

