/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.compare;

import com.atlassian.stash.compare.CompareRef;
import com.atlassian.stash.content.AbstractDiffRequest;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;

public class CompareDiffRequest
extends AbstractDiffRequest {
    private final CompareRef fromRef;
    private final CompareRef toRef;

    private CompareDiffRequest(Builder builder) {
        super(builder);
        this.fromRef = builder.fromRef;
        this.toRef = builder.toRef;
    }

    @Nonnull
    public CompareRef getFromRef() {
        return this.fromRef;
    }

    @Nonnull
    public CompareRef getToRef() {
        return this.toRef;
    }

    public static class Builder
    extends AbstractDiffRequest.AbstractBuilder<Builder, CompareDiffRequest> {
        private CompareRef fromRef;
        private CompareRef toRef;

        @Override
        @Nonnull
        public CompareDiffRequest build() {
            Preconditions.checkArgument((this.fromRef != null && this.toRef != null ? 1 : 0) != 0, (Object)"both a source and target ref are required");
            return new CompareDiffRequest(this);
        }

        @Nonnull
        public Builder fromRef(CompareRef fromRef) {
            this.fromRef = (CompareRef)Preconditions.checkNotNull((Object)fromRef, (Object)"fromRef");
            return this.self();
        }

        @Nonnull
        public Builder toRef(CompareRef toRef) {
            this.toRef = (CompareRef)Preconditions.checkNotNull((Object)toRef, (Object)"toRef");
            return this.self();
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

