/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.event.pull;

import com.atlassian.stash.event.CancelableEvent;
import com.atlassian.stash.event.annotation.TransactionAware;
import com.atlassian.stash.event.pull.PullRequestEvent;
import com.atlassian.stash.i18n.KeyedMessage;
import com.atlassian.stash.pull.PullRequest;
import com.atlassian.stash.pull.PullRequestAction;
import com.atlassian.stash.user.StashUser;
import com.atlassian.stash.util.CancelState;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nonnull;

@TransactionAware(value=TransactionAware.When.IMMEDIATE)
public class PullRequestOpenRequestedEvent
extends PullRequestEvent
implements CancelableEvent {
    private final CancelState cancelState;
    private final Set<StashUser> reviewers;

    public PullRequestOpenRequestedEvent(@Nonnull Object source, @Nonnull PullRequest pullRequest, @Nonnull Set<StashUser> reviewers, @Nonnull CancelState cancelState) {
        super(source, pullRequest, PullRequestAction.OPENED);
        this.cancelState = (CancelState)Preconditions.checkNotNull((Object)cancelState, (Object)"cancelState");
        this.reviewers = Collections.unmodifiableSet((Set)Preconditions.checkNotNull(reviewers, (Object)"reviewers"));
    }

    @Override
    public void cancel(@Nonnull KeyedMessage message) {
        this.cancelState.cancel(message);
    }

    @Nonnull
    public Set<StashUser> getReviewers() {
        return this.reviewers;
    }

    @Override
    public boolean isCanceled() {
        return this.cancelState.isCanceled();
    }
}

