/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.pull;

import com.atlassian.stash.pull.PullRequestRole;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PullRequestParticipantSearchRequest {
    private final Boolean approved;
    private final PullRequestRole role;
    private final String username;

    private PullRequestParticipantSearchRequest(Builder builder) {
        this.approved = builder.approved;
        this.role = builder.role;
        this.username = builder.username;
    }

    @Nullable
    public Boolean getApproved() {
        return this.approved;
    }

    @Nullable
    public PullRequestRole getRole() {
        return this.role;
    }

    @Nonnull
    public String getUsername() {
        return this.username;
    }

    public static class Builder {
        private final String username;
        private Boolean approved;
        private PullRequestRole role;

        public Builder(@Nonnull String username) {
            this.username = (String)Preconditions.checkNotNull((Object)username, (Object)"username");
        }

        @Nonnull
        public PullRequestParticipantSearchRequest build() {
            return new PullRequestParticipantSearchRequest(this);
        }

        @Nonnull
        public Builder approved(@Nullable Boolean approved) {
            this.approved = approved;
            return this;
        }

        @Nonnull
        public Builder role(@Nullable PullRequestRole role) {
            this.role = role;
            return this;
        }
    }
}

