/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.scm;

import com.atlassian.stash.scm.AbstractCommandParameters;
import com.atlassian.stash.user.StashUser;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class AbstractMergeCommandParameters
extends AbstractCommandParameters {
    private final StashUser author;
    private final boolean dryRun;
    private final String message;

    @Deprecated
    public AbstractMergeCommandParameters(StashUser author, boolean dryRun, String message) {
        this.author = author;
        this.dryRun = dryRun;
        this.message = message;
    }

    protected AbstractMergeCommandParameters(AbstractBuilder<?> builder) {
        this(builder.author, builder.dryRun, builder.message);
    }

    @Nonnull
    public StashUser getAuthor() {
        return this.author;
    }

    @Nullable
    public String getMessage() {
        return this.message;
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public static abstract class AbstractBuilder<B extends AbstractBuilder<B>> {
        protected StashUser author;
        protected boolean dryRun;
        protected String message;

        public B author(StashUser value) {
            this.author = (StashUser)Preconditions.checkNotNull((Object)value);
            return this.self();
        }

        public B dryRun(boolean value) {
            this.dryRun = value;
            return this.self();
        }

        public B message(String value) {
            this.message = value;
            return this.self();
        }

        protected abstract B self();

        protected void validate() {
            if (this.author == null) {
                throw new IllegalStateException("When performing or testing a merge, an author is required");
            }
            if (StringUtils.isBlank((String)this.author.getDisplayName())) {
                throw new IllegalStateException("When performing a merge, the author must have a display name");
            }
            if (StringUtils.isBlank((String)this.author.getEmailAddress())) {
                throw new IllegalStateException("When performing a merge, the author must have an e-mail address");
            }
            if (!this.dryRun && StringUtils.isEmpty((String)this.message)) {
                throw new IllegalStateException("When performing a merge, a commit message is required");
            }
        }
    }
}

