/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.scm;

import com.atlassian.stash.repository.Repository;
import com.atlassian.stash.scm.AbstractMergeCommandParameters;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class MergeCommandParameters
extends AbstractMergeCommandParameters {
    private final String fromBranch;
    private final String fromChangesetId;
    private final Repository fromRepository;
    private final String toBranch;

    private MergeCommandParameters(Builder builder) {
        super(builder);
        this.fromBranch = builder.fromBranch;
        this.fromChangesetId = builder.fromChangesetId;
        this.fromRepository = builder.fromRepository;
        this.toBranch = builder.toBranch;
    }

    @Nonnull
    public String getFromBranch() {
        return this.fromBranch;
    }

    @Nullable
    public String getFromChangesetId() {
        return this.fromChangesetId;
    }

    @Nullable
    public Repository getFromRepository() {
        return this.fromRepository;
    }

    @Nonnull
    public String getToBranch() {
        return this.toBranch;
    }

    public boolean hasFromRepository() {
        return this.fromRepository != null;
    }

    public static class Builder
    extends AbstractMergeCommandParameters.AbstractBuilder<Builder> {
        private String fromBranch;
        private String fromChangesetId;
        private Repository fromRepository;
        private String toBranch;

        public MergeCommandParameters build() {
            this.validate();
            return new MergeCommandParameters(this);
        }

        public Builder fromBranch(String value) {
            this.fromBranch = MergeCommandParameters.checkNotBlank(value, "fromBranch");
            return this.self();
        }

        public Builder fromChangesetId(String value) {
            this.fromChangesetId = value;
            return this.self();
        }

        public Builder fromRepository(@Nullable Repository value) {
            this.fromRepository = value;
            return this.self();
        }

        public Builder toBranch(String value) {
            this.toBranch = MergeCommandParameters.checkNotBlank(value, "toBranch");
            return this.self();
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        protected void validate() {
            super.validate();
            if (StringUtils.isBlank((String)this.fromBranch)) {
                throw new IllegalStateException("When performing a merge, the name of the branch to merge from is required");
            }
            if (StringUtils.isBlank((String)this.toBranch)) {
                throw new IllegalStateException("When performing a merge, the name of the branch to merge into is required");
            }
        }
    }
}

