/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.user;

import com.atlassian.stash.user.Person;
import com.atlassian.stash.user.StashUserVisitor;
import com.atlassian.stash.user.UserType;
import com.atlassian.stash.validation.RequiredString;
import com.google.common.base.Function;
import java.security.Principal;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface StashUser
extends Person,
Principal {
    public static final int MAX_SLUG_LENGTH = 127;
    public static final String SLUG_REGEXP = "[^\\\\/]+";
    public static final Function<StashUser, Integer> TO_ID = new Function<StashUser, Integer>(){

        @Nullable
        public Integer apply(StashUser user) {
            return user.getId();
        }
    };

    public <T> T accept(@Nonnull StashUserVisitor<T> var1);

    @Nonnull
    @RequiredString(size=255)
    public String getDisplayName();

    @Nullable
    public Integer getId();

    @Nonnull
    public UserType getType();

    public boolean isActive();

    @Nonnull
    @RequiredString(size=127, regexp="[^\\\\/]+")
    public String getSlug();
}

