/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.rest.client.httpclient;

import com.atlassian.stash.rest.client.api.StashException;
import com.atlassian.stash.rest.client.core.http.HttpExecutor;
import com.atlassian.stash.rest.client.core.http.HttpRequest;
import com.atlassian.stash.rest.client.core.http.HttpResponseProcessor;
import com.atlassian.stash.rest.client.httpclient.HttpClientConfig;
import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;

public class HttpClientHttpExecutor
implements HttpExecutor {
    private final DefaultHttpClient httpClient;
    private final URL baseUrl;
    private final BasicHttpContext forceBasicAuthContext;

    public HttpClientHttpExecutor(@Nonnull HttpClientConfig config) {
        this.baseUrl = config.getBaseUrl();
        this.httpClient = new DefaultHttpClient();
        this.forceBasicAuthContext = new BasicHttpContext();
        this.initCredentials(config);
    }

    private void initCredentials(HttpClientConfig config) {
        if (!Strings.isNullOrEmpty((String)config.getUsername())) {
            URL hostUrl = config.getBaseUrl();
            String scheme = (String)Objects.firstNonNull((Object)hostUrl.getProtocol(), (Object)"http");
            int port = hostUrl.getPort() != -1 ? hostUrl.getPort() : ("https".equalsIgnoreCase(scheme) ? 443 : 80);
            HttpHost targetHost = new HttpHost(hostUrl.getHost(), port, scheme);
            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(config.getUsername(), config.getPassword());
            this.httpClient.getCredentialsProvider().setCredentials(new AuthScope(targetHost), (Credentials)credentials);
            BasicAuthCache authCache = new BasicAuthCache();
            BasicScheme basicAuth = new BasicScheme();
            authCache.put(targetHost, (AuthScheme)basicAuth);
            this.forceBasicAuthContext.setAttribute("http.auth.auth-cache", (Object)authCache);
        }
    }

    @Nullable
    public <T> T execute(@Nonnull HttpRequest httpRequest, @Nonnull HttpResponseProcessor<T> responseProcessor) throws StashException {
        HttpRequestBase request = null;
        try {
            request = this.createRequest(httpRequest);
            HttpResponse response = this.httpClient.execute((HttpUriRequest)request, (HttpContext)(httpRequest.isAnonymous() ? null : this.forceBasicAuthContext));
            StatusLine status = response.getStatusLine();
            Map<String, String> headers = this.toHeaderMultimap(response.getAllHeaders());
            InputStream bodyStream = response.getEntity().getContent();
            com.atlassian.stash.rest.client.core.http.HttpResponse coreResponse = new com.atlassian.stash.rest.client.core.http.HttpResponse(status.getStatusCode(), status.getReasonPhrase(), headers, bodyStream);
            Object object = responseProcessor.process(coreResponse);
            return (T)object;
        }
        catch (IOException e) {
            throw new StashException((Throwable)e);
        }
        finally {
            if (request != null) {
                request.reset();
            }
        }
    }

    private Map<String, String> toHeaderMultimap(Header[] headers) {
        LinkedHashMap headerMap = Maps.newLinkedHashMap();
        for (Header header : headers) {
            String name;
            String existingValue = (String)headerMap.get(name = header.getName().toLowerCase());
            headerMap.put(name, existingValue == null ? header.getValue() : existingValue + "," + header.getValue());
        }
        return ImmutableMap.copyOf((Map)headerMap);
    }

    private HttpRequestBase createRequest(HttpRequest httpRequest) {
        URI fullUri = URI.create(this.baseUrl + "/" + httpRequest.getUrl()).normalize();
        switch (httpRequest.getMethod()) {
            case GET: {
                return new HttpGet(fullUri);
            }
            case POST: {
                HttpPost request = new HttpPost(fullUri);
                String payload = httpRequest.getPayload();
                if (payload != null) {
                    request.setEntity((HttpEntity)new StringEntity(payload, ContentType.APPLICATION_JSON));
                }
                return request;
            }
        }
        throw new UnsupportedOperationException(String.format("http method %s is not supported", httpRequest.getMethod()));
    }
}

