/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.tunnel.concurrent;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class NamedThreadFactory
implements ThreadFactory {
    private static final AtomicInteger factoryNumber = new AtomicInteger(1);
    private final ThreadGroup group;
    private final AtomicInteger threadNumber = new AtomicInteger(1);
    private final ThreadNameProvider threadNameProvider;
    private final boolean daemonMode;

    public NamedThreadFactory(String name, boolean daemonMode) {
        this(ThreadNameProvider.fixedNamePrefixProvider(name), daemonMode);
    }

    public NamedThreadFactory(ThreadNameProvider threadNameProvider, boolean daemonMode) {
        this.threadNameProvider = threadNameProvider;
        this.daemonMode = daemonMode;
        SecurityManager s = System.getSecurityManager();
        this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread t = new Thread(this.group, r, this.threadNameProvider.getName(this.threadNumber.getAndIncrement()), 0L);
        t.setDaemon(this.daemonMode);
        if (t.getPriority() != 5) {
            t.setPriority(5);
        }
        return t;
    }

    static /* synthetic */ AtomicInteger access$000() {
        return factoryNumber;
    }

    public static abstract class ThreadNameProvider {
        private static final int thisFactoryNumber = NamedThreadFactory.access$000().getAndIncrement();

        public String getName(int threadNo) {
            return this.getNamePrefix() + "-" + thisFactoryNumber + "-thread-" + threadNo;
        }

        protected abstract String getNamePrefix();

        public static ThreadNameProvider fixedNamePrefixProvider(final String threadNamePrefix) {
            return new ThreadNameProvider(){

                @Override
                protected String getNamePrefix() {
                    return threadNamePrefix;
                }
            };
        }
    }
}

