/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.tunnel.tunnel;

import com.atlassian.tunnel.tunnel.StreamProvider;
import com.atlassian.tunnel.utils.IOUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;

public class Repeater
implements Runnable {
    private static final Logger log = Logger.getLogger(Repeater.class);
    private static final AtomicInteger COUNTER = new AtomicInteger(0);
    private final InputStream source;
    private final OutputStream destination;
    private final String name;
    private final Runnable[] shutdownListeners;
    private final String repeaterId;

    public Repeater(StreamProvider source, StreamProvider destination, String name, Runnable ... shutdownListeners) {
        this.source = source.getInputStream();
        this.destination = destination.getOutputStream();
        this.name = name;
        this.shutdownListeners = shutdownListeners;
        this.repeaterId = Integer.toString(COUNTER.incrementAndGet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block14: {
            try {
                int len;
                byte[] byArray = new byte[8192];
                while ((len = this.read(byArray)) >= 0) {
                    if (log.isTraceEnabled()) {
                        this.logData(byArray, len);
                    }
                    this.write(byArray, len);
                }
            }
            catch (InterruptedIOException interruptedIOException) {
                log.debug((Object)("Terminating repeater " + this.name));
                IOUtils.closeQuietly(this.source);
                IOUtils.closeQuietly(this.destination);
                if (this.shutdownListeners == null) break block14;
                for (Runnable shutdownListener : this.shutdownListeners) {
                    shutdownListener.run();
                }
            }
            catch (IOException iOException) {
                if (log.isDebugEnabled()) {
                    String msg = "This is most likely normal: error while repeating traffic by repeater " + this.name + ":" + this.repeaterId;
                    if (iOException.getMessage().contains("Socket closed")) {
                        log.debug((Object)(msg + " " + iOException));
                    }
                    log.debug((Object)msg, (Throwable)iOException);
                }
            }
            catch (RuntimeException runtimeException) {
                log.error((Object)"Repeater error: ", (Throwable)runtimeException);
            }
            finally {
                log.debug((Object)("Terminating repeater " + this.name));
                IOUtils.closeQuietly(this.source);
                IOUtils.closeQuietly(this.destination);
                if (this.shutdownListeners == null) break block14;
                for (Runnable shutdownListener : this.shutdownListeners) {
                    shutdownListener.run();
                }
            }
        }
    }

    private void write(byte[] bytes, int len) throws IOException {
        this.destination.write(bytes, 0, len);
        this.destination.flush();
    }

    private int read(byte[] bytes) throws IOException {
        return this.source.read(bytes);
    }

    private void logData(byte[] bytes, int len) {
        try {
            CharsetDecoder decoder = IOUtils.UTF_8.newDecoder();
            CharBuffer charBuffer = decoder.decode(ByteBuffer.wrap(bytes, 0, len));
            log.trace((Object)("Forwarding data through tunnel (" + this.name + "-" + this.repeaterId + ")"));
            Logger.getLogger((String)(Repeater.class.getPackage().getName() + ".repeater." + this.name + "." + this.repeaterId)).trace((Object)charBuffer.toString());
        }
        catch (CharacterCodingException e) {
            log.trace((Object)("Forwarding non UTF-8 data through tunnel (" + this.name + "-" + this.repeaterId + ")"));
        }
    }
}

