/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.tunnel.tunnel;

import com.atlassian.tunnel.tunnel.StreamProvider;
import com.atlassian.tunnel.utils.IOUtils;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Logger;

public class SocketAndStreams
implements Closeable,
StreamProvider {
    private static final Logger log = Logger.getLogger(SocketAndStreams.class);
    private final OutputStream outputStream;
    private final AtomicBoolean isOutputStreamClosed = new AtomicBoolean();
    private final InputStream inputStream;
    private final AtomicBoolean isInputStreamClosed = new AtomicBoolean();
    private final Socket socket;

    public SocketAndStreams(Socket socket) throws IOException {
        this.socket = socket;
        this.outputStream = socket.getOutputStream();
        this.inputStream = socket.getInputStream();
    }

    @Override
    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    @Override
    public InputStream getInputStream() {
        return this.inputStream;
    }

    @Override
    public void close() throws IOException {
        this.socket.close();
    }

    public Runnable onInputStreamShutdown() {
        return new SocketShutdownController(this.socket, this.inputStream, this.isInputStreamClosed, this.isOutputStreamClosed);
    }

    public Runnable onOutputStreamShutdown() {
        return new SocketShutdownController(this.socket, this.outputStream, this.isOutputStreamClosed, this.isInputStreamClosed);
    }

    public Socket getSocket() {
        return this.socket;
    }

    private static class SocketShutdownController
    implements Runnable {
        private final Socket socket;
        private final Closeable controlledCloseable;
        private final AtomicBoolean controlledCloseableIsClosed;
        private final AtomicBoolean watchedCloseableIsClosed;

        public SocketShutdownController(Socket socket, Closeable controlledCloseable, AtomicBoolean controlledCloseableIsClosed, AtomicBoolean watchedCloseableIsClosed) {
            this.socket = socket;
            this.controlledCloseable = controlledCloseable;
            this.controlledCloseableIsClosed = controlledCloseableIsClosed;
            this.watchedCloseableIsClosed = watchedCloseableIsClosed;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            log.debug((Object)("Closing stream: " + this.controlledCloseable));
            IOUtils.closeQuietly(this.controlledCloseable);
            this.controlledCloseableIsClosed.set(true);
            Socket socket = this.socket;
            synchronized (socket) {
                if (this.watchedCloseableIsClosed.get()) {
                    log.debug((Object)("All streams closed, closing socket " + this.socket.getLocalPort() + "/" + this.socket.getPort()));
                    IOUtils.closeQuietly(this.socket);
                }
            }
        }
    }
}

