/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.tunnel.tunnel.client;

import com.atlassian.tunnel.tunnel.client.TunnelStatusTracker;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class DefaultTunnelStatusTracker
implements TunnelStatusTracker {
    private static final Logger log = Logger.getLogger(DefaultTunnelStatusTracker.class);
    private static final int CONSECUTIVE_RETRIES_THRESHOLD1 = 30;
    private static final int CONSECUTIVE_RETRIES_THRESHOLD2 = 60;
    private static final int RETRY_DELAY1 = 5;
    private static final int RETRY_DELAY2 = 15;
    private static final int RETRY_DELAY3 = 30;
    protected int consecutiveFailures;
    protected String tunnelName;
    protected boolean atLeastOneConnectionWasSuccessful;

    @Override
    public void onAttempt() {
    }

    @Override
    public void onStreamEnd() {
        log.debug((Object)"Stream ended. Assuming tunnel recycle.");
    }

    @Override
    public void onFailure() throws InterruptedException {
        this.onFailure(null);
    }

    @Override
    public void onFailure(@Nullable Throwable t) throws InterruptedException {
        ++this.consecutiveFailures;
        int delaySeconds = this.consecutiveFailures < 30 ? (this.consecutiveFailures == 1 && this.atLeastOneConnectionWasSuccessful ? 0 : 5) : (this.consecutiveFailures < 60 ? 15 : 30);
        String message = "Unable to establish the tunnel connection. Retrying in " + delaySeconds + "s. Connection: " + this.tunnelName + (t != null ? " failed with exception " + t.getMessage() : "");
        if (log.isDebugEnabled() || delaySeconds == 0) {
            log.debug((Object)message, t);
        } else if (delaySeconds == 30 || this.atLeastOneConnectionWasSuccessful) {
            log.info((Object)message);
        }
        TimeUnit.SECONDS.sleep(delaySeconds);
    }

    @Override
    public void setTunnelName(String tunnelName) {
        this.tunnelName = tunnelName;
    }

    @Override
    public void onSuccess() {
        this.consecutiveFailures = 0;
        this.atLeastOneConnectionWasSuccessful = true;
    }

    @Override
    public void finish() {
        log.debug((Object)(this.tunnelName + " is being closed."));
    }
}

