/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.tunnel.tunnel.client;

import com.atlassian.tunnel.concurrent.NamedThreadFactory;
import com.atlassian.tunnel.tunnel.Repeater;
import com.atlassian.tunnel.tunnel.SocketAndStreams;
import com.atlassian.tunnel.tunnel.StreamProvider;
import com.atlassian.tunnel.tunnel.client.DefaultTunnelStatusTracker;
import com.atlassian.tunnel.tunnel.client.TunnelServerAddressProvider;
import com.atlassian.tunnel.tunnel.client.TunnelStatusTracker;
import com.atlassian.tunnel.utils.IOUtils;
import com.atlassian.tunnel.utils.SecureSocketUtils;
import com.atlassian.tunnel.utils.SocketUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocket;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Tunnel
implements Runnable {
    private static final Logger log = Logger.getLogger(Tunnel.class);
    private final TunnelStatusTracker statusTracker;
    private volatile boolean isClosed;
    private final List<SocketAndStreams> allTunnelSockets = new CopyOnWriteArrayList<SocketAndStreams>();
    private final int remoteProxyPort;
    private final TunnelServerAddressProvider tunnelAddressProvider;
    private final InetAddress destinationHost;
    private final int destinationPort;
    private final SocketFactory tunnelSocketFactory;
    private final SocketFactory forwardingSocketFactory;
    private final Thread tunnelThread;
    private final ExecutorService repeaterExecutorService;
    private Socket destinationSocket;
    private volatile Socket tunnelSocket;

    private Runnable removeSocketOnRepeaterTermination(final SocketAndStreams tunnelSocket) {
        return new Runnable(){

            @Override
            public void run() {
                Tunnel.this.allTunnelSockets.remove(tunnelSocket);
            }
        };
    }

    private static Socket getRemoteSocket(InetAddress hostname, int port, SocketFactory socketFactory) throws IOException {
        Socket socket = socketFactory.createSocket();
        SocketUtils.configureSocket(socket);
        if (socket instanceof SSLSocket) {
            SecureSocketUtils.configureSocket((SSLSocket)socket);
        }
        socket.connect(new InetSocketAddress(hostname, port), 0);
        return socket;
    }

    public Tunnel(int remoteProxyPort, final @NotNull TunnelServerAddressProvider tunnelAddressProvider, @NotNull InetAddress destinationHost, final int destinationPort, @Nullable TunnelStatusTracker statusTracker, @NotNull SocketFactory tunnelSocketFactory, @NotNull SocketFactory forwardingSocketFactory) {
        this.remoteProxyPort = remoteProxyPort;
        this.destinationHost = destinationHost;
        this.destinationPort = destinationPort;
        this.tunnelSocketFactory = tunnelSocketFactory;
        this.forwardingSocketFactory = forwardingSocketFactory;
        this.tunnelAddressProvider = tunnelAddressProvider;
        this.statusTracker = statusTracker == null ? new DefaultTunnelStatusTracker() : statusTracker;
        boolean daemonMode = true;
        this.tunnelThread = new Thread((Runnable)this, "tunnel:" + destinationPort + "-" + remoteProxyPort);
        this.tunnelThread.setDaemon(daemonMode);
        NamedThreadFactory.ThreadNameProvider repeaterThreadNameProvider = new NamedThreadFactory.ThreadNameProvider(){

            @Override
            public String getNamePrefix() {
                return "repeater:" + tunnelAddressProvider.getTunnelPort() + "-" + destinationPort;
            }
        };
        this.repeaterExecutorService = Executors.newCachedThreadPool(new NamedThreadFactory(repeaterThreadNameProvider, daemonMode));
    }

    public Thread open() {
        this.tunnelThread.start();
        return this.tunnelThread;
    }

    public void close() {
        this.isClosed = true;
        IOUtils.closeQuietly(this.destinationSocket);
        IOUtils.closeQuietly(this.tunnelSocket);
        this.tunnelThread.interrupt();
        this.repeaterExecutorService.shutdownNow();
    }

    @Override
    public void run() {
        try {
            this.runTunnel();
        }
        catch (InterruptedIOException | InterruptedException e) {
            log.debug((Object)e);
        }
        this.close();
        this.statusTracker.finish();
    }

    public synchronized void closeAllTunnels(String previousAddressStr) {
        InetSocketAddress previousAddress = new InetSocketAddress(previousAddressStr, 0);
        Socket currentTunnelSocket = this.tunnelSocket;
        if (currentTunnelSocket != null && SocketUtils.isAddressTheSame(previousAddress, currentTunnelSocket.getRemoteSocketAddress())) {
            log.info((Object)"Closing current tunnel socket.");
            IOUtils.closeQuietly(currentTunnelSocket);
        }
        ArrayList<SocketAndStreams> toRemove = new ArrayList<SocketAndStreams>();
        for (SocketAndStreams runningTunnelSocket : this.allTunnelSockets) {
            if (!SocketUtils.isAddressTheSame(previousAddress, runningTunnelSocket.getSocket().getRemoteSocketAddress())) continue;
            toRemove.add(runningTunnelSocket);
            IOUtils.closeQuietly(runningTunnelSocket);
        }
        log.info((Object)("Closed " + toRemove.size() + " tunnel sockets"));
        for (SocketAndStreams closedSocket : toRemove) {
            this.allTunnelSockets.remove(closedSocket);
        }
    }

    private void runTunnel() throws InterruptedException, InterruptedIOException {
        String confInitial = "<config reverse=\"" + this.remoteProxyPort + ":init\"/>";
        String confContinue = "<config reverse=\"" + this.remoteProxyPort + "\"/>";
        String conf = confInitial;
        while (!Thread.currentThread().isInterrupted() && !this.isClosed) {
            String tunnelName = this.getTunnelName();
            this.statusTracker.setTunnelName(tunnelName);
            this.statusTracker.onAttempt();
            try {
                log.debug((Object)("Establishing: " + tunnelName + "..."));
                this.tunnelSocket = Tunnel.getRemoteSocket(this.tunnelAddressProvider.getTunnelAddress(), this.tunnelAddressProvider.getTunnelPort(), this.tunnelSocketFactory);
                SocketAndStreams socketAndStreams = new SocketAndStreams(this.tunnelSocket);
                InputStream din = socketAndStreams.getInputStream();
                OutputStream dout = socketAndStreams.getOutputStream();
                dout.write(conf.getBytes());
                conf = confContinue;
                this.startRepeaters(tunnelName, socketAndStreams, this.syncWithRemoteEnd(din));
            }
            catch (SocketTimeoutException e) {
                IOUtils.closeQuietly(this.tunnelSocket);
                this.statusTracker.onFailure(e);
            }
            catch (InterruptedIOException exception) {
                throw exception;
            }
            catch (RuntimeException e) {
                log.error((Object)"Unexpected exception during tunnel setup", (Throwable)e);
                this.statusTracker.onFailure(e);
            }
            catch (IOException e) {
                this.statusTracker.onFailure(e);
            }
        }
    }

    private void startRepeaters(@NotNull String tunnelName, @NotNull SocketAndStreams tunnelSocket, @Nullable byte[] initialData) throws IOException {
        if (initialData == null) {
            return;
        }
        this.destinationSocket = Tunnel.getRemoteSocket(this.destinationHost, this.destinationPort, this.forwardingSocketFactory);
        if (initialData.length != 0) {
            this.destinationSocket.getOutputStream().write(initialData);
        }
        StreamProvider destinationSocketStreamProvider = this.asStreamProvider(this.destinationSocket);
        this.allTunnelSockets.add(tunnelSocket);
        Runnable removeSocketOnRepeaterTermination = this.removeSocketOnRepeaterTermination(tunnelSocket);
        this.repeaterExecutorService.submit(new Repeater(tunnelSocket, destinationSocketStreamProvider, "ext->" + this.destinationPort, removeSocketOnRepeaterTermination));
        this.repeaterExecutorService.submit(new Repeater(destinationSocketStreamProvider, tunnelSocket, "ext<-" + this.destinationPort, removeSocketOnRepeaterTermination));
        log.debug((Object)("Established: " + tunnelName + "."));
    }

    private StreamProvider asStreamProvider(Socket socket) throws IOException {
        final InputStream inputStream = socket.getInputStream();
        final OutputStream outputStream = socket.getOutputStream();
        return new StreamProvider(){

            @Override
            public InputStream getInputStream() {
                return inputStream;
            }

            @Override
            public OutputStream getOutputStream() {
                return outputStream;
            }
        };
    }

    @Nullable
    private byte[] syncWithRemoteEnd(InputStream din) throws IOException, InterruptedException {
        boolean syncCanBeFound;
        StringBuilder readData = new StringBuilder();
        String syncText = "<sync/>";
        byte[] bytes = new byte[1024];
        boolean syncFound = false;
        String readString = null;
        do {
            int len;
            if ((len = din.read(bytes)) > 0) {
                readData.append(new String(bytes, 0, len));
                readString = readData.toString();
                syncFound = readString.startsWith("<sync/>");
                if (syncFound) {
                    this.statusTracker.onSuccess();
                } else {
                    log.debug((Object)("Read string doesn't begin with '<sync/>'. String was: " + readString));
                    this.statusTracker.onFailure();
                }
            } else {
                this.statusTracker.onStreamEnd();
            }
            boolean bl = syncCanBeFound = len > 0 && (syncFound || readString == null || readString.length() < "<sync/>".length());
        } while (!syncFound && syncCanBeFound && !Thread.currentThread().isInterrupted());
        if (!syncFound) {
            return null;
        }
        return readString.substring(readString.indexOf(">") + 1).getBytes();
    }

    private String getTunnelName() {
        InetAddress tunnelHost = this.tunnelAddressProvider.getTunnelAddress();
        int tunnelPort = this.tunnelAddressProvider.getTunnelPort();
        return "Tunnel " + tunnelHost + ":" + this.remoteProxyPort + " - (" + tunnelHost + ":" + tunnelPort + ") - " + this.destinationHost + ":" + this.destinationPort;
    }
}

