/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.tunnel.tunnel.server;

import com.atlassian.tunnel.tunnel.Repeater;
import com.atlassian.tunnel.tunnel.SocketAndStreams;
import com.atlassian.tunnel.utils.IOUtils;
import com.atlassian.tunnel.utils.SocketUtils;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

class LocalAcceptor
implements Runnable {
    private static final Logger log = Logger.getLogger(LocalAcceptor.class);
    private final ServerSocket serverSocket;
    private final SocketAndStreams externalTunnelSocket;
    private final ExecutorService executor;
    private final int maximumExternalConnectionUptimeMs;

    LocalAcceptor(ServerSocket localTunnelSocket, SocketAndStreams externalTunnelSocket, ExecutorService executor, int maximumExternalConnectionUptimeMs) throws IOException {
        this.serverSocket = localTunnelSocket;
        this.externalTunnelSocket = externalTunnelSocket;
        this.executor = executor;
        this.maximumExternalConnectionUptimeMs = maximumExternalConnectionUptimeMs;
    }

    @Override
    public void run() {
        block4: {
            SocketAndStreams connectionToLocalTunnel = null;
            try {
                log.debug((Object)("Waiting for a local connection to port " + this.serverSocket.getLocalPort() + "."));
                long start = System.currentTimeMillis();
                connectionToLocalTunnel = this.acceptLocalConnection();
                if (connectionToLocalTunnel == null) {
                    return;
                }
                long tunnelAge = TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - start);
                log.info((Object)("Accepted a local connection on port " + this.serverSocket.getLocalPort() + ", tunnel age: " + tunnelAge + "s"));
                this.externalTunnelSocket.getOutputStream().write("<sync/>".getBytes());
                this.executor.execute(new Repeater(this.externalTunnelSocket, connectionToLocalTunnel, "ext->" + this.serverSocket.getLocalPort(), this.externalTunnelSocket.onInputStreamShutdown(), connectionToLocalTunnel.onOutputStreamShutdown()));
                this.executor.execute(new Repeater(connectionToLocalTunnel, this.externalTunnelSocket, this.serverSocket.getLocalPort() + "->ext", this.externalTunnelSocket.onOutputStreamShutdown(), connectionToLocalTunnel.onInputStreamShutdown()));
            }
            catch (RuntimeException e) {
                IOUtils.closeQuietly(this.externalTunnelSocket);
                IOUtils.closeQuietly(connectionToLocalTunnel);
                log.error((Object)"Error while accepting local connections.", (Throwable)e);
            }
            catch (IOException e) {
                if (e instanceof InterruptedIOException) break block4;
                log.error((Object)"Error while accepting local connections.", (Throwable)e);
            }
        }
    }

    @Nullable
    private SocketAndStreams acceptLocalConnection() throws IOException {
        Socket connectionToLocalTunnel = SocketUtils.socketAccept(this.serverSocket, this.maximumExternalConnectionUptimeMs);
        if (connectionToLocalTunnel == null) {
            log.debug((Object)("No local connections detected in the alotted time of " + this.maximumExternalConnectionUptimeMs + "ms, recycling tunnel"));
            IOUtils.closeQuietly(this.externalTunnelSocket);
            return null;
        }
        connectionToLocalTunnel.setTcpNoDelay(true);
        connectionToLocalTunnel.setKeepAlive(true);
        return new SocketAndStreams(connectionToLocalTunnel);
    }
}

