/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.tunnel.tunnel.server;

import com.atlassian.tunnel.tunnel.SocketAndStreams;
import com.atlassian.tunnel.tunnel.server.LocalAcceptor;
import com.atlassian.tunnel.tunnel.server.TunnelListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.BindException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.net.ServerSocketFactory;
import org.apache.log4j.Logger;

class TunnelAcceptor
implements Runnable {
    private static final Logger log = Logger.getLogger(TunnelAcceptor.class);
    private static final ConcurrentMap<Integer, ServerSocket> socketMap = new ConcurrentHashMap<Integer, ServerSocket>();
    private final Socket externalTunnelSocket;
    private final TunnelListener tunnelListener;
    private final ExecutorService executor;
    private final int maximumExternalConnectionUptimeMs;

    TunnelAcceptor(Socket externalTunnelSocket, TunnelListener tunnelListener, ExecutorService executor, int maximumExternalConnectionUptimeMs) {
        this.externalTunnelSocket = externalTunnelSocket;
        this.tunnelListener = tunnelListener;
        this.executor = executor;
        this.maximumExternalConnectionUptimeMs = maximumExternalConnectionUptimeMs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            int len;
            this.externalTunnelSocket.setTcpNoDelay(true);
            this.externalTunnelSocket.setKeepAlive(true);
            InputStream in = this.externalTunnelSocket.getInputStream();
            byte[] bytes = new byte[1024];
            StringBuilder config = new StringBuilder();
            while ((len = in.read(bytes)) >= 0) {
                String configStr;
                config.append(new String(bytes, 0, len));
                String str = config.toString();
                if (!str.startsWith("<config") || !str.contains("/>") || !(configStr = str.substring(0, str.indexOf(">") + 1)).startsWith("<config reverse=")) continue;
                int lport = Integer.parseInt(configStr.substring(configStr.indexOf("=") + 2, configStr.indexOf("/") - 1).split(":")[0]);
                log.debug((Object)("Tunnel connection at port " + this.externalTunnelSocket.getPort() + " ready to accept data from port " + lport));
                ServerSocket localTunnelSocket = null;
                ConcurrentMap<Integer, ServerSocket> concurrentMap = socketMap;
                synchronized (concurrentMap) {
                    if (configStr.contains("init")) {
                        ServerSocket oldSocket = (ServerSocket)socketMap.remove(lport);
                        if (oldSocket != null) {
                            try {
                                log.info((Object)("Closing server socket for port " + lport));
                                oldSocket.close();
                            }
                            catch (IOException e) {
                                log.error((Object)"Could not close old connection.", (Throwable)e);
                            }
                        }
                    } else {
                        localTunnelSocket = (ServerSocket)socketMap.get(lport);
                    }
                    if (localTunnelSocket == null) {
                        try {
                            localTunnelSocket = TunnelAcceptor.bindPort(lport);
                        }
                        catch (BindException e) {
                            log.error((Object)("Could not bind to port '" + lport + "'. Retrying in 5 seconds..."), (Throwable)e);
                            Thread.sleep(TimeUnit.SECONDS.toMillis(5L));
                            localTunnelSocket = TunnelAcceptor.bindPort(lport);
                        }
                    }
                }
                this.executor.execute(new LocalAcceptor(localTunnelSocket, new SocketAndStreams(this.externalTunnelSocket), this.executor, this.maximumExternalConnectionUptimeMs));
                if (this.tunnelListener != null) {
                    this.tunnelListener.tunnelAccepted(lport);
                }
                break;
            }
        }
        catch (InterruptedIOException in) {
        }
        catch (InterruptedException in) {
        }
        catch (RuntimeException e) {
            log.error((Object)"Error while accepting tunnel connections.", (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)"Error while accepting tunnel connections.", (Throwable)e);
        }
    }

    private static ServerSocket bindPort(int port) throws IOException {
        ServerSocket serverSocket = ServerSocketFactory.getDefault().createServerSocket(port);
        socketMap.put(port, serverSocket);
        return serverSocket;
    }
}

