/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.tunnel.tunnel.server;

import com.atlassian.tunnel.concurrent.NamedThreadFactory;
import com.atlassian.tunnel.tunnel.server.TunnelAcceptor;
import com.atlassian.tunnel.tunnel.server.TunnelListener;
import com.atlassian.tunnel.utils.IOUtils;
import com.atlassian.tunnel.utils.SecureSocketUtils;
import com.atlassian.tunnel.utils.SocketUtils;
import java.io.Closeable;
import java.io.IOException;
import java.net.Socket;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.net.ServerSocketFactory;
import javax.net.ssl.SSLServerSocket;
import org.apache.log4j.Logger;

public class TunnelServer
implements Runnable,
Closeable {
    private static final Logger log = Logger.getLogger(TunnelServer.class);
    private final ServerSocketFactory ssocketFactory;
    private final TunnelListener tunnelListener;
    private final ExecutorService executor;
    private final int port;
    private static final int MAXIMUM_EXTERNAL_CONNECTION_UPTIME_MS = (int)TimeUnit.MINUTES.toMillis(4L);
    private int maximumExternalConnectionUptimeMs = MAXIMUM_EXTERNAL_CONNECTION_UPTIME_MS;
    private SSLServerSocket ssocket;

    public TunnelServer(int port, ServerSocketFactory ssocketFactory, TunnelListener tunnelListener) {
        this.port = port;
        this.ssocketFactory = ssocketFactory;
        this.tunnelListener = tunnelListener;
        boolean daemonMode = true;
        this.executor = Executors.newCachedThreadPool(new NamedThreadFactory("tunnelserver:" + port, daemonMode));
    }

    @Override
    public void run() {
        try {
            this.ssocket = (SSLServerSocket)this.ssocketFactory.createServerSocket(this.port);
            SecureSocketUtils.configureSocket(this.ssocket);
            while (!Thread.currentThread().isInterrupted()) {
                this.acceptTunnelRequest();
            }
        }
        catch (RuntimeException e) {
            log.fatal((Object)"Fatal error in TunnelServer.", (Throwable)e);
        }
        catch (IOException e) {
            log.fatal((Object)"Fatal error in TunnelServer.", (Throwable)e);
        }
        this.executor.shutdownNow();
    }

    public void setMaximumExternalConnectionUptimeMs(int maximumExternalConnectionUptimeMs) {
        this.maximumExternalConnectionUptimeMs = maximumExternalConnectionUptimeMs;
    }

    private void acceptTunnelRequest() {
        Socket socket;
        log.debug((Object)"Waiting for the next external tunnel connection.");
        try {
            socket = SocketUtils.socketAccept(this.ssocket, 0);
            if (socket == null) {
                return;
            }
            log.debug((Object)("Accepted an external tunnel connection at port " + socket.getPort()));
        }
        catch (RuntimeException e) {
            log.error((Object)"Error accepting connection.", (Throwable)e);
            return;
        }
        catch (IOException e) {
            log.error((Object)"Error accepting connection.", (Throwable)e);
            return;
        }
        try {
            this.executor.execute(new TunnelAcceptor(socket, this.tunnelListener, this.executor, this.maximumExternalConnectionUptimeMs));
        }
        catch (RuntimeException e) {
            IOUtils.closeQuietly(socket);
            throw e;
        }
    }

    @Override
    public void close() throws IOException {
        IOUtils.closeQuietly(this.ssocket);
    }
}

