/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.tunnel.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLSocket;
import org.apache.log4j.Logger;

public final class SecureSocketUtils {
    private static final Logger log = Logger.getLogger(SecureSocketUtils.class);
    private static final boolean isRc4Forced;
    private static boolean disableClientAuth;
    private static boolean allowAnonKex;
    private static final AtomicReference<SecureCipherSuitesAndProtocols> serverSocketConfiguration;
    private static final AtomicReference<SecureCipherSuitesAndProtocols> clientSocketConfiguration;

    private SecureSocketUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void configureSocket(SSLServerSocket ssocket) {
        AtomicReference<SecureCipherSuitesAndProtocols> socketConfiguration;
        if (!disableClientAuth) {
            ssocket.setNeedClientAuth(true);
        }
        AtomicReference<SecureCipherSuitesAndProtocols> atomicReference = socketConfiguration = serverSocketConfiguration;
        synchronized (atomicReference) {
            if (socketConfiguration.get() == null) {
                socketConfiguration.set(new SecureCipherSuitesAndProtocols(ssocket.getSupportedCipherSuites(), ssocket.getSupportedProtocols()));
                log.debug((Object)("Server: " + Arrays.toString(socketConfiguration.get().getSecureCipherSuites())));
            }
        }
        ssocket.setEnabledCipherSuites(socketConfiguration.get().getSecureCipherSuites());
        ssocket.setEnabledProtocols(socketConfiguration.get().getSecureProtocols());
        ssocket.getSSLParameters().setUseCipherSuitesOrder(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void configureSocket(SSLSocket socket) {
        AtomicReference<SecureCipherSuitesAndProtocols> socketConfiguration;
        AtomicReference<SecureCipherSuitesAndProtocols> atomicReference = socketConfiguration = clientSocketConfiguration;
        synchronized (atomicReference) {
            if (socketConfiguration.get() == null) {
                socketConfiguration.set(new SecureCipherSuitesAndProtocols(socket.getSupportedCipherSuites(), socket.getSupportedProtocols()));
                log.debug((Object)("Client: " + Arrays.toString(socketConfiguration.get().getSecureCipherSuites())));
            }
        }
        socket.setEnabledCipherSuites(socketConfiguration.get().getSecureCipherSuites());
        socket.setEnabledProtocols(socketConfiguration.get().getSecureProtocols());
        socket.getSSLParameters().setUseCipherSuitesOrder(true);
    }

    private static void removeDangerousCipherSuites(Collection<String> cipherSuites) {
        SecureSocketUtils.remove(cipherSuites, "_NULL_");
        if (!isRc4Forced) {
            SecureSocketUtils.remove(cipherSuites, "_RC4_");
        }
        SecureSocketUtils.remove(cipherSuites, "_EXPORT_");
        SecureSocketUtils.remove(cipherSuites, "_MD5");
        SecureSocketUtils.remove(cipherSuites, "_DES_");
        if (!allowAnonKex) {
            SecureSocketUtils.remove(cipherSuites, "_anon_");
        }
        SecureSocketUtils.remove(cipherSuites, "_3DES_");
        SecureSocketUtils.remove(cipherSuites, "_GCM_");
    }

    private static void remove(Collection<String> cipherSuites, String match) {
        Iterator<String> cipherSuitesIterator = cipherSuites.iterator();
        while (cipherSuitesIterator.hasNext()) {
            String cipherSuite = cipherSuitesIterator.next();
            if (!cipherSuite.contains(match)) continue;
            SecureSocketUtils.removeUnlessLast(cipherSuites, cipherSuitesIterator);
        }
    }

    private static void matchOldLevel(ArrayList<String> cipherSuites) {
    }

    private static void matchIntermediateLevel(Iterable<String> cipherSuites, Collection<String> protocols) {
        if (SecureSocketUtils.removeUnlessLast(protocols, "SSLv3")) {
            Iterator<String> cipherSuiteIterator = cipherSuites.iterator();
            while (cipherSuiteIterator.hasNext()) {
                String cipherSuite = cipherSuiteIterator.next();
                if (!cipherSuite.startsWith("SSL")) continue;
                cipherSuiteIterator.remove();
            }
        }
    }

    private static void matchModernLevel(Collection<String> cipherSuites, Collection<String> protocols) {
        SecureSocketUtils.removeUnlessLastMatching(cipherSuites, ".*_SHA");
        protocols.remove("SSLv2Hello");
        SecureSocketUtils.removeUnlessLast(protocols, "TLSv1");
        SecureSocketUtils.removeUnlessLast(protocols, "TLSv1.1");
    }

    private static boolean removeUnlessLast(Collection<String> strings, Iterator<String> string) {
        if (strings.size() > 1) {
            string.remove();
            return true;
        }
        return false;
    }

    private static boolean removeUnlessLast(Collection<String> strings, String string) {
        if (strings.size() > 1) {
            return strings.remove(string);
        }
        return false;
    }

    private static boolean removeUnlessLastMatching(Collection<String> strings, String regex) {
        if (strings.size() == 1) {
            return false;
        }
        Iterator<String> stringIterator = strings.iterator();
        Pattern pattern = Pattern.compile(regex);
        boolean matchFound = false;
        while (stringIterator.hasNext()) {
            String str = stringIterator.next();
            if (pattern.matcher(str).matches()) {
                matchFound = true;
                stringIterator.remove();
            }
            if (strings.size() != 1) continue;
            return matchFound;
        }
        return matchFound;
    }

    public static void disableClientAuth() {
        disableClientAuth = true;
    }

    public static void allowAnonKex() {
        allowAnonKex = true;
    }

    static {
        disableClientAuth = false;
        allowAnonKex = false;
        String ephemeralKeySize = "jdk.tls.ephemeralDHKeySize";
        if (System.getProperty("jdk.tls.ephemeralDHKeySize") == null) {
            System.setProperty("jdk.tls.ephemeralDHKeySize", "matched");
        }
        isRc4Forced = Boolean.getBoolean("tunnel.enable.rc4");
        serverSocketConfiguration = new AtomicReference();
        clientSocketConfiguration = new AtomicReference();
    }

    private static class SecureCipherSuitesAndProtocols {
        private final String[] safeCipherSuites;
        private final String[] safeProtocols;

        private SecureCipherSuitesAndProtocols(String[] cipherSuitesArr, String[] protocolsArr) {
            ArrayList<String> cipherSuites = new ArrayList<String>(Arrays.asList(cipherSuitesArr));
            ArrayList<String> protocols = new ArrayList<String>(Arrays.asList(protocolsArr));
            SecureSocketUtils.removeDangerousCipherSuites(cipherSuites);
            SecureSocketUtils.matchOldLevel(cipherSuites);
            SecureSocketUtils.matchIntermediateLevel(cipherSuites, protocols);
            SecureSocketUtils.matchModernLevel(cipherSuites, protocols);
            this.safeCipherSuites = cipherSuites.toArray(new String[cipherSuites.size()]);
            this.safeProtocols = protocols.toArray(new String[protocols.size()]);
        }

        public String[] getSecureCipherSuites() {
            return this.safeCipherSuites;
        }

        public String[] getSecureProtocols() {
            return this.safeProtocols;
        }
    }
}

