/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.tunnel.utils;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Arrays;
import org.jetbrains.annotations.Nullable;

public final class SocketUtils {
    private static int testTimeout = -1;

    private SocketUtils() {
    }

    @Nullable
    public static Socket socketAccept(ServerSocket socket, int timeoutMs) throws IOException {
        if (testTimeout > 0 && (timeoutMs == 0 || timeoutMs > testTimeout)) {
            timeoutMs = testTimeout;
        }
        socket.setSoTimeout(timeoutMs);
        try {
            return socket.accept();
        }
        catch (SocketTimeoutException ignored) {
            return null;
        }
        catch (SocketException e) {
            if (Thread.currentThread().isInterrupted()) {
                return null;
            }
            throw e;
        }
    }

    public static void configureSocket(Socket socket) throws SocketException {
        socket.setTcpNoDelay(true);
        socket.setKeepAlive(true);
    }

    public static boolean isAddressTheSame(InetSocketAddress address1, SocketAddress address2) {
        if (!(address2 instanceof InetSocketAddress)) {
            return false;
        }
        InetSocketAddress inetSocketAddress = (InetSocketAddress)address2;
        return SocketUtils.isIpAddressTheSame(inetSocketAddress, address1);
    }

    private static boolean isIpAddressTheSame(InetSocketAddress address1, InetSocketAddress address2) {
        byte[] bytesIpAddress1 = address1.getAddress().getAddress();
        byte[] bytesIpAddress2 = address2.getAddress().getAddress();
        return Arrays.equals(bytesIpAddress1, bytesIpAddress2);
    }

    public static void forceTimeoutMs(int timeoutMs) {
        testTimeout = timeoutMs;
    }
}

