/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.tunnel.utils.http.proxy;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class HttpTunnelSocket
extends Socket {
    private static final Logger log = Logger.getLogger(HttpTunnelSocket.class);
    private static final String PROTOCOL_VERSION_REQUEST = "HTTP/1.0";
    static final String PROTOCOL_CHARSET = "US-ASCII";
    private static final Pattern EXPECTED_RESPONSE = Pattern.compile("HTTP/1\\.[01] 200");
    private static final char CR = '\r';
    private static final char LF = '\n';
    private static final String CRLF = "\r\n";
    private static final int RESPONSE_BUFFER_LIMIT = 8192;
    private final InetSocketAddress httpProxyAddress;
    private final String httpUserAgent;
    private volatile HttpProxySocketDelegate delegate;

    public HttpTunnelSocket(InetSocketAddress httpProxyAddress, String httpUserAgent) {
        this.httpProxyAddress = httpProxyAddress;
        this.httpUserAgent = httpUserAgent;
    }

    @Override
    public void connect(SocketAddress remoteAddress, int timeout) throws IOException {
        this.getDelegate().connect(this.httpProxyAddress, timeout);
        this.tunnel((InetSocketAddress)remoteAddress);
    }

    private void tunnel(InetSocketAddress remoteAddress) throws IOException {
        this.sendConnectRequest(remoteAddress);
        this.waitForConnectionResponse(remoteAddress);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Established a tunnel connection to %s:%s via CONNECT method through the %s:%s HTTP proxy.", remoteAddress.getHostName(), remoteAddress.getPort(), this.httpProxyAddress.getHostName(), this.httpProxyAddress.getPort()));
        }
    }

    private void sendConnectRequest(InetSocketAddress remoteAddress) throws IOException {
        String connectionCommand = "CONNECT " + remoteAddress.getHostName() + ":" + remoteAddress.getPort() + " " + PROTOCOL_VERSION_REQUEST;
        String userAgent = "User-Agent: " + this.httpUserAgent;
        this.sendConnectionRequest(connectionCommand, userAgent);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Requested \"%s\" with \"%s\".", connectionCommand, userAgent));
        }
    }

    private String sendConnectionRequest(String connectionCommand, String userAgent) throws IOException {
        OutputStream httpProxyOutputStream = this.getDelegate().getOutputStream();
        String connectRequest = connectionCommand + CRLF + userAgent + CRLF + CRLF;
        httpProxyOutputStream.write(this.toBytes(connectRequest));
        httpProxyOutputStream.flush();
        return connectionCommand;
    }

    private void waitForConnectionResponse(InetSocketAddress remoteAddress) throws IOException {
        InputStream httpProxyInputStream = this.getDelegate().getInputStream();
        String actualResponse = HttpTunnelSocket.getStatusLineFromHeader(httpProxyInputStream, 8192);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Received response \"%s\".", actualResponse));
        }
        if (!EXPECTED_RESPONSE.matcher(actualResponse).find()) {
            throw new IOException(String.format("Unable to establish a tunnel connection %s:%s via CONNECT method through the %s:%s HTTP proxy. Expected the response to start with \"%s\" but the proxy returned \"%s\".", remoteAddress.getHostName(), remoteAddress.getPort(), this.httpProxyAddress.getHostName(), this.httpProxyAddress.getPort(), EXPECTED_RESPONSE.pattern(), actualResponse));
        }
    }

    static String getStatusLineFromHeader(InputStream inputStream, int headerLimit) throws IOException {
        int byteAsInt;
        byte[] statusLine = new byte[1024];
        int statusLineBytes = 0;
        int headerBytes = 0;
        boolean isFirstLine = true;
        int previousByteAsInt = -1;
        boolean isHeaderComplete = false;
        while (statusLineBytes < statusLine.length && headerBytes < headerLimit && (byteAsInt = inputStream.read()) != -1) {
            ++headerBytes;
            if (byteAsInt == 13) continue;
            if (byteAsInt == 10) {
                isFirstLine = false;
                if (previousByteAsInt == 10) {
                    isHeaderComplete = true;
                    break;
                }
            }
            if (isFirstLine) {
                statusLine[statusLineBytes++] = (byte)byteAsInt;
            }
            previousByteAsInt = byteAsInt;
        }
        if (!isHeaderComplete) {
            throw new IllegalArgumentException("Proxy headers were malformed or longer than " + headerLimit);
        }
        return HttpTunnelSocket.toString(statusLine, statusLineBytes).trim();
    }

    private byte[] toBytes(String string) {
        try {
            return string.getBytes(PROTOCOL_CHARSET);
        }
        catch (UnsupportedEncodingException ignored) {
            return string.getBytes();
        }
    }

    private static String toString(byte[] bytes, int length) {
        try {
            return new String(bytes, 0, length, PROTOCOL_CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            return new String(bytes, 0, length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpProxySocketDelegate getDelegate() {
        if (this.delegate == null) {
            HttpTunnelSocket httpTunnelSocket = this;
            synchronized (httpTunnelSocket) {
                if (this.delegate == null) {
                    this.delegate = new HttpProxySocketDelegate(){

                        @Override
                        public void connect(SocketAddress httpProxyAddress, int timeout) throws IOException {
                            try {
                                HttpTunnelSocket.super.connect(httpProxyAddress, timeout);
                            }
                            catch (IOException ioe) {
                                throw this.handleIOException(timeout, ioe);
                            }
                        }

                        @Override
                        public OutputStream getOutputStream() throws IOException {
                            return HttpTunnelSocket.super.getOutputStream();
                        }

                        @Override
                        public InputStream getInputStream() throws IOException {
                            return HttpTunnelSocket.super.getInputStream();
                        }

                        private IOException handleIOException(int timeout, IOException ioe) {
                            if (ioe instanceof UnknownHostException) {
                                log.error((Object)String.format("The host %s could not be resolved.", HttpTunnelSocket.this.httpProxyAddress.getHostName()));
                            } else if (ioe instanceof ConnectException && "Connection timed out".equals(ioe.getMessage())) {
                                if (timeout == 0) {
                                    // empty if block
                                }
                                log.error((Object)String.format("The connection to port %s on %s could not be established%s.", HttpTunnelSocket.this.httpProxyAddress.getPort(), HttpTunnelSocket.this.httpProxyAddress.getHostName(), timeout == 0 ? "" : " waited" + TimeUnit.MILLISECONDS.toSeconds(timeout) + " " + TimeUnit.SECONDS.name().toLowerCase()));
                            }
                            return ioe;
                        }
                    };
                }
            }
        }
        return this.delegate;
    }

    void setDelegate(HttpProxySocketDelegate delegate) {
        this.delegate = delegate;
    }

    static interface HttpProxySocketDelegate {
        public void connect(SocketAddress var1, int var2) throws IOException;

        public OutputStream getOutputStream() throws IOException;

        public InputStream getInputStream() throws IOException;
    }
}

