/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.tunnel.utils.http.proxy;

import com.atlassian.tunnel.utils.http.proxy.HttpTunnelSocket;
import com.atlassian.tunnel.utils.http.proxy.SSLSocketDecorator;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HttpTunnelSocketFactory
extends SocketFactory {
    private final InetSocketAddress httpProxyAddress;
    private final SSLContext sslContext;
    private final String httpUserAgent;

    public HttpTunnelSocketFactory(@NotNull InetSocketAddress httpProxyAddress, @Nullable SSLContext sslContext, @NotNull String httpUserAgent) {
        this.httpProxyAddress = httpProxyAddress;
        this.sslContext = sslContext;
        this.httpUserAgent = httpUserAgent;
    }

    @Override
    public Socket createSocket() throws IOException {
        HttpTunnelSocket httpTunnelSocket = new HttpTunnelSocket(this.httpProxyAddress, this.httpUserAgent);
        return this.sslContext == null ? httpTunnelSocket : new SSLSocketDecorator(httpTunnelSocket, this.sslContext);
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        throw new UnsupportedOperationException();
    }
}

