/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.tunnel.utils.http.proxy;

import com.atlassian.tunnel.utils.http.proxy.SSLSocketDelegate;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class SSLSocketDecorator
extends SSLSocketDelegate {
    private static final Logger log = Logger.getLogger(SSLSocketDecorator.class);
    private final Socket socket;
    private final SSLSocketFactory sslSocketFactory;
    private final String[] contextSupportedProtocols;
    private final String[] contextEnabledProtocols;
    private SSLSocket secureTunnelSocket;

    public SSLSocketDecorator(@NotNull Socket socket, @NotNull SSLContext sslContext) {
        this.socket = socket;
        this.sslSocketFactory = sslContext.getSocketFactory();
        this.contextSupportedProtocols = sslContext.getSupportedSSLParameters().getProtocols();
        this.contextEnabledProtocols = sslContext.getDefaultSSLParameters().getProtocols();
    }

    @Override
    protected SSLSocket getSecureSocketDelegate() {
        return this.secureTunnelSocket;
    }

    @Override
    protected SSLSocketFactory getSslSocketFactory() {
        return this.sslSocketFactory;
    }

    @Override
    public String[] getSupportedProtocols() {
        if (this.secureTunnelSocket != null) {
            return this.secureTunnelSocket.getSupportedProtocols();
        }
        return this.contextSupportedProtocols;
    }

    @Override
    public String[] getEnabledProtocols() {
        if (this.secureTunnelSocket != null) {
            return this.secureTunnelSocket.getEnabledProtocols();
        }
        if (this.enabledProtocols != null) {
            return this.enabledProtocols;
        }
        return this.contextEnabledProtocols;
    }

    @Override
    public synchronized void connect(SocketAddress endpoint, int timeout) throws IOException {
        this.configure(this.socket);
        this.socket.connect(endpoint, timeout);
        this.secureTunnelSocket = this.createSslSocketOverPlainSocket(this.socket, (InetSocketAddress)endpoint);
        this.configure(this.secureTunnelSocket);
        this.configureSsl(this.secureTunnelSocket);
        this.handshake(this.secureTunnelSocket);
    }

    private void configureSsl(SSLSocket sslSocket) {
        if (this.enabledProtocols != null) {
            sslSocket.setEnabledProtocols(this.enabledProtocols);
        }
        if (this.enabledCipherSuites != null) {
            sslSocket.setEnabledCipherSuites(this.enabledCipherSuites);
        }
        if (this.sslParameters != null) {
            sslSocket.getSSLParameters().setUseCipherSuitesOrder(this.sslParameters.getUseCipherSuitesOrder());
        }
    }

    private void configure(Socket socket) throws SocketException {
        if (this.tcpNoDelay != null) {
            socket.setTcpNoDelay(this.tcpNoDelay);
        }
        if (this.keepAlive != null) {
            socket.setKeepAlive(this.keepAlive);
        }
    }

    @Override
    public synchronized void close() throws IOException {
        String socketDescription;
        boolean wasPlainSocketConnected = this.socket.isConnected();
        if (this.secureTunnelSocket == null) {
            socketDescription = this.socket.toString();
            this.socket.close();
            if (wasPlainSocketConnected) {
                log.error((Object)String.format("%s has been closed. This is a programming error, the socket should have not been open in the first place since secureTunnelSocket is null.", socketDescription));
            }
        } else {
            socketDescription = this.secureTunnelSocket.toString();
            this.secureTunnelSocket.close();
            this.secureTunnelSocket = null;
            if (log.isDebugEnabled() && wasPlainSocketConnected) {
                log.debug((Object)String.format("%s has been closed.", socketDescription));
            }
        }
        if (!wasPlainSocketConnected) {
            log.warn((Object)String.format("%s was not connected, close() was superfluous.", socketDescription));
        }
    }

    private void handshake(SSLSocket secureTunnelSocket) throws IOException {
        if (log.isDebugEnabled()) {
            secureTunnelSocket.addHandshakeCompletedListener(new HandshakeCompletedListener(){

                @Override
                public void handshakeCompleted(HandshakeCompletedEvent event) {
                    log.debug((Object)String.format("SSL handshake has been completed [CipherSuite: %s, SessionId: %s, PeerHost: %s].", event.getCipherSuite(), event.getSession(), event.getSession().getPeerHost()));
                }
            });
        }
        secureTunnelSocket.startHandshake();
    }

    private SSLSocket createSslSocketOverPlainSocket(Socket socket, InetSocketAddress address) throws IOException {
        boolean autoClose = true;
        return (SSLSocket)this.sslSocketFactory.createSocket(socket, address.getHostName(), address.getPort(), true);
    }
}

