/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.tunnel.utils.http.proxy;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.SocketChannel;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public abstract class SSLSocketDelegate
extends SSLSocket {
    protected volatile Boolean tcpNoDelay;
    protected volatile Boolean keepAlive;
    protected volatile String[] enabledProtocols;
    protected volatile String[] enabledCipherSuites;
    protected volatile SSLParameters sslParameters;

    protected abstract SSLSocket getSecureSocketDelegate();

    protected abstract SSLSocketFactory getSslSocketFactory();

    @Override
    public String[] getSupportedCipherSuites() {
        SSLSocket sslSocket = this.getSecureSocketDelegate();
        if (sslSocket == null) {
            return this.getSslSocketFactory().getSupportedCipherSuites();
        }
        return sslSocket.getSupportedCipherSuites();
    }

    @Override
    public String[] getEnabledCipherSuites() {
        SSLSocket sslSocket = this.getSecureSocketDelegate();
        if (sslSocket != null) {
            return sslSocket.getEnabledCipherSuites();
        }
        if (this.enabledCipherSuites != null) {
            return this.enabledCipherSuites;
        }
        return this.getSslSocketFactory().getDefaultCipherSuites();
    }

    @Override
    public void setEnabledCipherSuites(String[] suites) {
        SSLSocket sslSocket = this.getSecureSocketDelegate();
        if (sslSocket == null) {
            this.enabledCipherSuites = suites;
        } else {
            sslSocket.setEnabledCipherSuites(suites);
        }
    }

    @Override
    public abstract String[] getSupportedProtocols();

    @Override
    public abstract String[] getEnabledProtocols();

    @Override
    public void setEnabledProtocols(String[] protocols) {
        SSLSocket sslSocket = this.getSecureSocketDelegate();
        if (sslSocket == null) {
            this.enabledProtocols = protocols;
        } else {
            sslSocket.setEnabledProtocols(protocols);
        }
    }

    @Override
    public SSLSession getSession() {
        return this.getSecureSocketDelegate().getSession();
    }

    @Override
    public void addHandshakeCompletedListener(HandshakeCompletedListener listener) {
        this.getSecureSocketDelegate().addHandshakeCompletedListener(listener);
    }

    @Override
    public void removeHandshakeCompletedListener(HandshakeCompletedListener listener) {
        this.getSecureSocketDelegate().removeHandshakeCompletedListener(listener);
    }

    @Override
    public void startHandshake() throws IOException {
        this.getSecureSocketDelegate().startHandshake();
    }

    @Override
    public void setUseClientMode(boolean mode) {
        this.getSecureSocketDelegate().setUseClientMode(mode);
    }

    @Override
    public boolean getUseClientMode() {
        return this.getSecureSocketDelegate().getUseClientMode();
    }

    @Override
    public void setNeedClientAuth(boolean need) {
        this.getSecureSocketDelegate().setNeedClientAuth(need);
    }

    @Override
    public boolean getNeedClientAuth() {
        return this.getSecureSocketDelegate().getNeedClientAuth();
    }

    @Override
    public void connect(SocketAddress endpoint) throws IOException {
        this.getSecureSocketDelegate().connect(endpoint);
    }

    @Override
    public void setWantClientAuth(boolean want) {
        this.getSecureSocketDelegate().setWantClientAuth(want);
    }

    @Override
    public void connect(SocketAddress endpoint, int timeout) throws IOException {
        this.getSecureSocketDelegate().connect(endpoint, timeout);
    }

    @Override
    public boolean getWantClientAuth() {
        return this.getSecureSocketDelegate().getWantClientAuth();
    }

    @Override
    public void setEnableSessionCreation(boolean flag) {
        this.getSecureSocketDelegate().setEnableSessionCreation(flag);
    }

    @Override
    public boolean getEnableSessionCreation() {
        return this.getSecureSocketDelegate().getEnableSessionCreation();
    }

    @Override
    public SSLParameters getSSLParameters() {
        SSLSocket secureSocketDelegate = this.getSecureSocketDelegate();
        if (secureSocketDelegate == null) {
            this.sslParameters = new SSLParameters();
            return this.sslParameters;
        }
        return secureSocketDelegate.getSSLParameters();
    }

    @Override
    public void bind(SocketAddress bindpoint) throws IOException {
        this.getSecureSocketDelegate().bind(bindpoint);
    }

    @Override
    public void setSSLParameters(SSLParameters params) {
        this.getSecureSocketDelegate().setSSLParameters(params);
    }

    @Override
    public InetAddress getInetAddress() {
        return this.getSecureSocketDelegate().getInetAddress();
    }

    @Override
    public InetAddress getLocalAddress() {
        return this.getSecureSocketDelegate().getLocalAddress();
    }

    @Override
    public int getPort() {
        return this.getSecureSocketDelegate().getPort();
    }

    @Override
    public int getLocalPort() {
        return this.getSecureSocketDelegate().getLocalPort();
    }

    @Override
    public SocketAddress getRemoteSocketAddress() {
        return this.getSecureSocketDelegate().getRemoteSocketAddress();
    }

    @Override
    public SocketAddress getLocalSocketAddress() {
        return this.getSecureSocketDelegate().getLocalSocketAddress();
    }

    @Override
    public SocketChannel getChannel() {
        return this.getSecureSocketDelegate().getChannel();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.getSecureSocketDelegate().getInputStream();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.getSecureSocketDelegate().getOutputStream();
    }

    @Override
    public void setTcpNoDelay(boolean on) throws SocketException {
        SSLSocket sslSocket = this.getSecureSocketDelegate();
        if (sslSocket == null) {
            this.tcpNoDelay = on;
        } else {
            sslSocket.setTcpNoDelay(on);
        }
    }

    @Override
    public boolean getTcpNoDelay() throws SocketException {
        return this.getSecureSocketDelegate().getTcpNoDelay();
    }

    @Override
    public void setSoLinger(boolean on, int linger) throws SocketException {
        this.getSecureSocketDelegate().setSoLinger(on, linger);
    }

    @Override
    public int getSoLinger() throws SocketException {
        return this.getSecureSocketDelegate().getSoLinger();
    }

    @Override
    public void sendUrgentData(int data) throws IOException {
        this.getSecureSocketDelegate().sendUrgentData(data);
    }

    @Override
    public void setOOBInline(boolean on) throws SocketException {
        this.getSecureSocketDelegate().setOOBInline(on);
    }

    @Override
    public boolean getOOBInline() throws SocketException {
        return this.getSecureSocketDelegate().getOOBInline();
    }

    @Override
    public void setSoTimeout(int timeout) throws SocketException {
        this.getSecureSocketDelegate().setSoTimeout(timeout);
    }

    @Override
    public int getSoTimeout() throws SocketException {
        return this.getSecureSocketDelegate().getSoTimeout();
    }

    @Override
    public void setSendBufferSize(int size) throws SocketException {
        this.getSecureSocketDelegate().setSendBufferSize(size);
    }

    @Override
    public int getSendBufferSize() throws SocketException {
        return this.getSecureSocketDelegate().getSendBufferSize();
    }

    @Override
    public void setReceiveBufferSize(int size) throws SocketException {
        this.getSecureSocketDelegate().setReceiveBufferSize(size);
    }

    @Override
    public int getReceiveBufferSize() throws SocketException {
        return this.getSecureSocketDelegate().getReceiveBufferSize();
    }

    @Override
    public void setKeepAlive(boolean on) throws SocketException {
        SSLSocket sslSocket = this.getSecureSocketDelegate();
        if (sslSocket == null) {
            this.keepAlive = on;
        } else {
            sslSocket.setKeepAlive(on);
        }
    }

    @Override
    public boolean getKeepAlive() throws SocketException {
        return this.getSecureSocketDelegate().getKeepAlive();
    }

    @Override
    public void setTrafficClass(int tc) throws SocketException {
        this.getSecureSocketDelegate().setTrafficClass(tc);
    }

    @Override
    public int getTrafficClass() throws SocketException {
        return this.getSecureSocketDelegate().getTrafficClass();
    }

    @Override
    public void setReuseAddress(boolean on) throws SocketException {
        this.getSecureSocketDelegate().setReuseAddress(on);
    }

    @Override
    public boolean getReuseAddress() throws SocketException {
        return this.getSecureSocketDelegate().getReuseAddress();
    }

    @Override
    public void close() throws IOException {
        this.getSecureSocketDelegate().close();
    }

    @Override
    public void shutdownInput() throws IOException {
        this.getSecureSocketDelegate().shutdownInput();
    }

    @Override
    public void shutdownOutput() throws IOException {
        this.getSecureSocketDelegate().shutdownOutput();
    }

    @Override
    public String toString() {
        return this.getSecureSocketDelegate().toString();
    }

    @Override
    public boolean isConnected() {
        return this.getSecureSocketDelegate().isConnected();
    }

    @Override
    public boolean isBound() {
        return this.getSecureSocketDelegate().isBound();
    }

    @Override
    public boolean isClosed() {
        return this.getSecureSocketDelegate().isClosed();
    }

    @Override
    public boolean isInputShutdown() {
        return this.getSecureSocketDelegate().isInputShutdown();
    }

    @Override
    public boolean isOutputShutdown() {
        return this.getSecureSocketDelegate().isOutputShutdown();
    }

    @Override
    public void setPerformancePreferences(int connectionTime, int latency, int bandwidth) {
        this.getSecureSocketDelegate().setPerformancePreferences(connectionTime, latency, bandwidth);
    }
}

