package com.atlassian.user.repository;

import java.io.Serializable;

/**
 * The identifier of a repository, which consists of a key and a name.
 *
 * The key is used as the unique identifier for the respository. The name is used in the user interface
 * for identifying the repository for a user.
 */
public interface RepositoryIdentifier extends Serializable
{
    /**
     * String uniquely identifying this repository. By default, it is configured in the key
     * attribute on the repository tag in the atlassian-user.xml file.
     * <p/>
     * Implementation should not allow the key to be <code>null</code>.
     */
    String getKey();

    /**
     * String with a more user-friendly name for the repository.
     * <p/>
     * Implementations should not allow the name to be <code>null</code>.
     */
    String getName();
}
