package com.atlassian.vcache.internal;

import java.util.Optional;
import java.util.function.Supplier;

/**
 * Represents the context for a request. Implementations must be thread-safe.
 *
 * @since 1.0.0
 */
public interface RequestContext {
    /**
     * Returns the partition identifier
     *
     * @return the partition identifier
     */
    String partitionIdentifier();

    /**
     * Returns the value associated with the specified key, or computes it atomically using the provided
     * supplier. The provided supplier <b>must not</b> attempt to perform any other mutations on the
     * request context.
     *
     * @param key      the key to retrieve the value under.
     * @param supplier the supplier to create the missing value. Should be short and sweet and not mutate the
     *                 request context.
     * @param <T>      the return type
     * @return the current value associated with the key, or a new value created with the provided supplier.
     */
    <T> T computeIfAbsent(Object key, Supplier<T> supplier);

    /**
     * Returns the value associated with the specified key, or {@link java.util.Optional#empty()}.
     */
    <T> Optional<T> get(Object key);
}
