/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.jwt.internal.org.bouncycastle.math.ec.endo;

import com.auth0.jwt.internal.org.bouncycastle.math.ec.ECConstants;
import com.auth0.jwt.internal.org.bouncycastle.math.ec.ECCurve;
import com.auth0.jwt.internal.org.bouncycastle.math.ec.ECPointMap;
import com.auth0.jwt.internal.org.bouncycastle.math.ec.ScaleXPointMap;
import com.auth0.jwt.internal.org.bouncycastle.math.ec.endo.GLVEndomorphism;
import com.auth0.jwt.internal.org.bouncycastle.math.ec.endo.GLVTypeBParameters;
import java.math.BigInteger;

public class GLVTypeBEndomorphism
implements GLVEndomorphism {
    protected final ECCurve curve;
    protected final GLVTypeBParameters parameters;
    protected final ECPointMap pointMap;

    public GLVTypeBEndomorphism(ECCurve eCCurve, GLVTypeBParameters gLVTypeBParameters) {
        this.curve = eCCurve;
        this.parameters = gLVTypeBParameters;
        this.pointMap = new ScaleXPointMap(eCCurve.fromBigInteger(gLVTypeBParameters.getBeta()));
    }

    public BigInteger[] decomposeScalar(BigInteger bigInteger) {
        int n = this.parameters.getBits();
        BigInteger bigInteger2 = this.calculateB(bigInteger, this.parameters.getG1(), n);
        BigInteger bigInteger3 = this.calculateB(bigInteger, this.parameters.getG2(), n);
        BigInteger[] bigIntegerArray = this.parameters.getV1();
        BigInteger[] bigIntegerArray2 = this.parameters.getV2();
        BigInteger bigInteger4 = bigInteger.subtract(bigInteger2.multiply(bigIntegerArray[0]).add(bigInteger3.multiply(bigIntegerArray2[0])));
        BigInteger bigInteger5 = bigInteger2.multiply(bigIntegerArray[1]).add(bigInteger3.multiply(bigIntegerArray2[1])).negate();
        return new BigInteger[]{bigInteger4, bigInteger5};
    }

    public ECPointMap getPointMap() {
        return this.pointMap;
    }

    public boolean hasEfficientPointMap() {
        return true;
    }

    protected BigInteger calculateB(BigInteger bigInteger, BigInteger bigInteger2, int n) {
        boolean bl = bigInteger2.signum() < 0;
        BigInteger bigInteger3 = bigInteger.multiply(bigInteger2.abs());
        boolean bl2 = bigInteger3.testBit(n - 1);
        bigInteger3 = bigInteger3.shiftRight(n);
        if (bl2) {
            bigInteger3 = bigInteger3.add(ECConstants.ONE);
        }
        return bl ? bigInteger3.negate() : bigInteger3;
    }
}

