/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.models;

import com.azure.ai.openai.models.ChatCompletionsToolCall;
import com.azure.ai.openai.models.ChatMessageContentItem;
import com.azure.ai.openai.models.ChatRequestMessage;
import com.azure.ai.openai.models.ChatRole;
import com.azure.ai.openai.models.FunctionCall;
import com.azure.core.util.BinaryData;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public final class ChatRequestAssistantMessage
extends ChatRequestMessage {
    private final BinaryData content;
    private final String stringContent;
    private final List<ChatMessageContentItem> chatMessageContentItems;
    private String name;
    private List<ChatCompletionsToolCall> toolCalls;
    private FunctionCall functionCall;
    private ChatRole role = ChatRole.ASSISTANT;
    private String refusal;

    public BinaryData getContent() {
        return this.content;
    }

    public List<ChatMessageContentItem> getListContent() {
        return this.chatMessageContentItems;
    }

    public ChatMessageContentItem[] getArrayContent() {
        return this.chatMessageContentItems == null ? null : this.chatMessageContentItems.toArray(new ChatMessageContentItem[0]);
    }

    public String getStringContent() {
        return this.stringContent;
    }

    public String getName() {
        return this.name;
    }

    public ChatRequestAssistantMessage setName(String name) {
        this.name = name;
        return this;
    }

    public List<ChatCompletionsToolCall> getToolCalls() {
        return this.toolCalls;
    }

    public ChatRequestAssistantMessage setToolCalls(List<ChatCompletionsToolCall> toolCalls) {
        this.toolCalls = toolCalls;
        return this;
    }

    public FunctionCall getFunctionCall() {
        return this.functionCall;
    }

    public ChatRequestAssistantMessage setFunctionCall(FunctionCall functionCall) {
        this.functionCall = functionCall;
        return this;
    }

    @Override
    public ChatRole getRole() {
        return this.role;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.stringContent != null) {
            jsonWriter.writeStringField("content", this.stringContent);
        } else if (this.chatMessageContentItems != null) {
            jsonWriter.writeArrayField("content", this.chatMessageContentItems, JsonWriter::writeJson);
        } else {
            jsonWriter.writeNullField("content");
        }
        jsonWriter.writeStringField("role", this.role == null ? null : this.role.toString());
        jsonWriter.writeStringField("refusal", this.refusal);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeArrayField("tool_calls", this.toolCalls, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("function_call", (JsonSerializable)this.functionCall);
        return jsonWriter.writeEndObject();
    }

    public static ChatRequestAssistantMessage fromJson(JsonReader jsonReader) throws IOException {
        return (ChatRequestAssistantMessage)jsonReader.readObject(reader -> {
            Object content = null;
            String stringContent = null;
            List chatMessageContentItems = null;
            ChatRole role = ChatRole.ASSISTANT;
            String refusal = null;
            String name = null;
            List toolCalls = null;
            FunctionCall functionCall = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("content".equals(fieldName)) {
                    if (reader.currentToken() == JsonToken.STRING) {
                        stringContent = reader.getString();
                        continue;
                    }
                    if (reader.currentToken() == JsonToken.START_ARRAY) {
                        chatMessageContentItems = reader.readArray(arrayReader -> (ChatMessageContentItem)arrayReader.readObject(ChatMessageContentItem::fromJson));
                        continue;
                    }
                    if (reader.currentToken() == JsonToken.NULL) {
                        content = null;
                        continue;
                    }
                    throw new IllegalStateException("Unexpected 'content' type found when deserializing ChatRequestAssistantMessage JSON object: " + reader.currentToken());
                }
                if ("role".equals(fieldName)) {
                    role = ChatRole.fromString(reader.getString());
                    continue;
                }
                if ("refusal".equals(fieldName)) {
                    refusal = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    continue;
                }
                if ("tool_calls".equals(fieldName)) {
                    toolCalls = reader.readArray(reader1 -> ChatCompletionsToolCall.fromJson(reader1));
                    continue;
                }
                if ("function_call".equals(fieldName)) {
                    functionCall = FunctionCall.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            ChatRequestAssistantMessage deserializedChatRequestAssistantMessage = CoreUtils.isNullOrEmpty(stringContent) && chatMessageContentItems == null ? new ChatRequestAssistantMessage(content) : (CoreUtils.isNullOrEmpty(stringContent) ? new ChatRequestAssistantMessage(chatMessageContentItems) : new ChatRequestAssistantMessage(stringContent));
            deserializedChatRequestAssistantMessage.role = role;
            deserializedChatRequestAssistantMessage.setRefusal(refusal).setName(name).setToolCalls(toolCalls).setFunctionCall(functionCall);
            return deserializedChatRequestAssistantMessage;
        });
    }

    private ChatRequestAssistantMessage(BinaryData content) {
        this.content = content;
        this.stringContent = null;
        this.chatMessageContentItems = null;
    }

    public ChatRequestAssistantMessage(String content) {
        this.content = content == null ? null : BinaryData.fromString((String)content);
        this.stringContent = content;
        this.chatMessageContentItems = null;
    }

    public ChatRequestAssistantMessage(List<ChatMessageContentItem> content) {
        this.content = BinaryData.fromObject(content);
        this.stringContent = null;
        this.chatMessageContentItems = content;
    }

    public ChatRequestAssistantMessage(ChatMessageContentItem[] content) {
        this.content = BinaryData.fromObject((Object)content);
        this.chatMessageContentItems = Arrays.asList(content);
        this.stringContent = null;
    }

    public String getRefusal() {
        return this.refusal;
    }

    public ChatRequestAssistantMessage setRefusal(String refusal) {
        this.refusal = refusal;
        return this;
    }
}

