/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.models;

import com.azure.ai.openai.models.AudioResponseData;
import com.azure.ai.openai.models.AzureChatExtensionsMessageContext;
import com.azure.ai.openai.models.ChatCompletionsToolCall;
import com.azure.ai.openai.models.ChatRole;
import com.azure.ai.openai.models.FunctionCall;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class ChatResponseMessage
implements JsonSerializable<ChatResponseMessage> {
    private final ChatRole role;
    private final String content;
    private List<ChatCompletionsToolCall> toolCalls;
    private FunctionCall functionCall;
    private AzureChatExtensionsMessageContext context;
    private final String refusal;
    private AudioResponseData audio;

    public ChatRole getRole() {
        return this.role;
    }

    public String getContent() {
        return this.content;
    }

    public List<ChatCompletionsToolCall> getToolCalls() {
        return this.toolCalls;
    }

    public FunctionCall getFunctionCall() {
        return this.functionCall;
    }

    public AzureChatExtensionsMessageContext getContext() {
        return this.context;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("role", this.role == null ? null : this.role.toString());
        jsonWriter.writeStringField("refusal", this.refusal);
        jsonWriter.writeStringField("content", this.content);
        jsonWriter.writeArrayField("tool_calls", this.toolCalls, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("function_call", (JsonSerializable)this.functionCall);
        jsonWriter.writeJsonField("audio", (JsonSerializable)this.audio);
        jsonWriter.writeJsonField("context", (JsonSerializable)this.context);
        return jsonWriter.writeEndObject();
    }

    public static ChatResponseMessage fromJson(JsonReader jsonReader) throws IOException {
        return (ChatResponseMessage)jsonReader.readObject(reader -> {
            ChatRole role = null;
            String refusal = null;
            String content = null;
            List toolCalls = null;
            FunctionCall functionCall = null;
            AudioResponseData audio = null;
            AzureChatExtensionsMessageContext context = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("role".equals(fieldName)) {
                    role = ChatRole.fromString(reader.getString());
                    continue;
                }
                if ("refusal".equals(fieldName)) {
                    refusal = reader.getString();
                    continue;
                }
                if ("content".equals(fieldName)) {
                    content = reader.getString();
                    continue;
                }
                if ("tool_calls".equals(fieldName)) {
                    toolCalls = reader.readArray(reader1 -> ChatCompletionsToolCall.fromJson(reader1));
                    continue;
                }
                if ("function_call".equals(fieldName)) {
                    functionCall = FunctionCall.fromJson(reader);
                    continue;
                }
                if ("audio".equals(fieldName)) {
                    audio = AudioResponseData.fromJson(reader);
                    continue;
                }
                if ("context".equals(fieldName)) {
                    context = AzureChatExtensionsMessageContext.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            ChatResponseMessage deserializedChatResponseMessage = new ChatResponseMessage(role, refusal, content);
            deserializedChatResponseMessage.toolCalls = toolCalls;
            deserializedChatResponseMessage.functionCall = functionCall;
            deserializedChatResponseMessage.audio = audio;
            deserializedChatResponseMessage.context = context;
            return deserializedChatResponseMessage;
        });
    }

    private ChatResponseMessage(ChatRole role, String refusal, String content) {
        this.role = role;
        this.refusal = refusal;
        this.content = content;
    }

    public String getRefusal() {
        return this.refusal;
    }

    public AudioResponseData getAudio() {
        return this.audio;
    }
}

