// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * A representation of a single polygon point as used by the Azure grounding enhancement.
 */
@Immutable
public final class AzureGroundingEnhancementCoordinatePoint {

    /*
     * The x-coordinate (horizontal axis) of the point.
     */
    @Generated
    @JsonProperty(value = "x")
    private double x;

    /*
     * The y-coordinate (vertical axis) of the point.
     */
    @Generated
    @JsonProperty(value = "y")
    private double y;

    /**
     * Creates an instance of AzureGroundingEnhancementCoordinatePoint class.
     *
     * @param x the x value to set.
     * @param y the y value to set.
     */
    @Generated
    @JsonCreator
    private AzureGroundingEnhancementCoordinatePoint(@JsonProperty(value = "x") double x,
        @JsonProperty(value = "y") double y) {
        this.x = x;
        this.y = y;
    }

    /**
     * Get the x property: The x-coordinate (horizontal axis) of the point.
     *
     * @return the x value.
     */
    @Generated
    public double getX() {
        return this.x;
    }

    /**
     * Get the y property: The y-coordinate (vertical axis) of the point.
     *
     * @return the y value.
     */
    @Generated
    public double getY() {
        return this.y;
    }
}
