// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * The authentication options for Azure OpenAI On Your Data when using a connection string.
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.PROPERTY, property = "type")
@JsonTypeName("connection_string")
@Immutable
public final class OnYourDataConnectionStringAuthenticationOptions extends OnYourDataAuthenticationOptions {

    /*
     * The connection string to use for authentication.
     */
    @Generated
    @JsonProperty(value = "connection_string")
    private String connectionString;

    /**
     * Creates an instance of OnYourDataConnectionStringAuthenticationOptions class.
     *
     * @param connectionString the connectionString value to set.
     */
    @Generated
    @JsonCreator
    public OnYourDataConnectionStringAuthenticationOptions(
        @JsonProperty(value = "connection_string") String connectionString) {
        this.connectionString = connectionString;
    }

    /**
     * Get the connectionString property: The connection string to use for authentication.
     *
     * @return the connectionString value.
     */
    @Generated
    public String getConnectionString() {
        return this.connectionString;
    }
}
