// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * The details of a a vectorization source, used by Azure OpenAI On Your Data when applying vector search, that is
 * based
 * on an internal embeddings model deployment name in the same Azure OpenAI resource.
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.PROPERTY, property = "type")
@JsonTypeName("deployment_name")
@Immutable
public final class OnYourDataDeploymentNameVectorizationSource extends OnYourDataVectorizationSource {

    /*
     * The embedding model deployment name within the same Azure OpenAI resource. This enables you to use vector search
     * without Azure OpenAI api-key and without Azure OpenAI public network access.
     */
    @Generated
    @JsonProperty(value = "deployment_name")
    private String deploymentName;

    /**
     * Creates an instance of OnYourDataDeploymentNameVectorizationSource class.
     *
     * @param deploymentName the deploymentName value to set.
     */
    @Generated
    @JsonCreator
    public OnYourDataDeploymentNameVectorizationSource(@JsonProperty(value = "deployment_name") String deploymentName) {
        this.deploymentName = deploymentName;
    }

    /**
     * Get the deploymentName property: The embedding model deployment name within the same Azure OpenAI resource. This
     * enables you to use vector search without Azure OpenAI api-key and without Azure OpenAI public network access.
     *
     * @return the deploymentName value.
     */
    @Generated
    public String getDeploymentName() {
        return this.deploymentName;
    }
}
