// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * The details of a a vectorization source, used by Azure OpenAI On Your Data when applying vector search, that is
 * based
 * on a public Azure OpenAI endpoint call for embeddings.
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.PROPERTY, property = "type")
@JsonTypeName("endpoint")
@Immutable
public final class OnYourDataEndpointVectorizationSource extends OnYourDataVectorizationSource {

    /*
     * Specifies the resource endpoint URL from which embeddings should be retrieved. It should be in the format of
     * https://YOUR_RESOURCE_NAME.openai.azure.com/openai/deployments/YOUR_DEPLOYMENT_NAME/embeddings. The api-version
     * query parameter is not allowed.
     */
    @Generated
    @JsonProperty(value = "endpoint")
    private String endpoint;

    /*
     * Specifies the authentication options to use when retrieving embeddings from the specified endpoint.
     */
    @Generated
    @JsonProperty(value = "authentication")
    private OnYourDataAuthenticationOptions authentication;

    /**
     * Creates an instance of OnYourDataEndpointVectorizationSource class.
     *
     * @param endpoint the endpoint value to set.
     * @param authentication the authentication value to set.
     */
    @Generated
    @JsonCreator
    public OnYourDataEndpointVectorizationSource(@JsonProperty(value = "endpoint") String endpoint,
        @JsonProperty(value = "authentication") OnYourDataAuthenticationOptions authentication) {
        this.endpoint = endpoint;
        this.authentication = authentication;
    }

    /**
     * Get the endpoint property: Specifies the resource endpoint URL from which embeddings should be retrieved. It
     * should be in the format of
     * https://YOUR_RESOURCE_NAME.openai.azure.com/openai/deployments/YOUR_DEPLOYMENT_NAME/embeddings. The api-version
     * query parameter is not allowed.
     *
     * @return the endpoint value.
     */
    @Generated
    public String getEndpoint() {
        return this.endpoint;
    }

    /**
     * Get the authentication property: Specifies the authentication options to use when retrieving embeddings from the
     * specified endpoint.
     *
     * @return the authentication value.
     */
    @Generated
    public OnYourDataAuthenticationOptions getAuthentication() {
        return this.authentication;
    }
}
