// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * Optional settings to control how fields are processed when using a configured Pinecone resource.
 */
@Fluent
public final class PineconeFieldMappingOptions {

    /*
     * The name of the index field to use as a title.
     */
    @Generated
    @JsonProperty(value = "title_field")
    private String titleField;

    /*
     * The name of the index field to use as a URL.
     */
    @Generated
    @JsonProperty(value = "url_field")
    private String urlField;

    /*
     * The name of the index field to use as a filepath.
     */
    @Generated
    @JsonProperty(value = "filepath_field")
    private String filepathField;

    /*
     * The names of index fields that should be treated as content.
     */
    @Generated
    @JsonProperty(value = "content_fields")
    private List<String> contentFields;

    /*
     * The separator pattern that content fields should use.
     */
    @Generated
    @JsonProperty(value = "content_fields_separator")
    private String contentFieldsSeparator;

    /**
     * Get the titleField property: The name of the index field to use as a title.
     *
     * @return the titleField value.
     */
    @Generated
    public String getTitleField() {
        return this.titleField;
    }

    /**
     * Set the titleField property: The name of the index field to use as a title.
     *
     * @param titleField the titleField value to set.
     * @return the PineconeFieldMappingOptions object itself.
     */
    @Generated
    public PineconeFieldMappingOptions setTitleField(String titleField) {
        this.titleField = titleField;
        return this;
    }

    /**
     * Get the urlField property: The name of the index field to use as a URL.
     *
     * @return the urlField value.
     */
    @Generated
    public String getUrlField() {
        return this.urlField;
    }

    /**
     * Set the urlField property: The name of the index field to use as a URL.
     *
     * @param urlField the urlField value to set.
     * @return the PineconeFieldMappingOptions object itself.
     */
    @Generated
    public PineconeFieldMappingOptions setUrlField(String urlField) {
        this.urlField = urlField;
        return this;
    }

    /**
     * Get the filepathField property: The name of the index field to use as a filepath.
     *
     * @return the filepathField value.
     */
    @Generated
    public String getFilepathField() {
        return this.filepathField;
    }

    /**
     * Set the filepathField property: The name of the index field to use as a filepath.
     *
     * @param filepathField the filepathField value to set.
     * @return the PineconeFieldMappingOptions object itself.
     */
    @Generated
    public PineconeFieldMappingOptions setFilepathField(String filepathField) {
        this.filepathField = filepathField;
        return this;
    }

    /**
     * Get the contentFields property: The names of index fields that should be treated as content.
     *
     * @return the contentFields value.
     */
    @Generated
    public List<String> getContentFields() {
        return this.contentFields;
    }

    /**
     * Get the contentFieldsSeparator property: The separator pattern that content fields should use.
     *
     * @return the contentFieldsSeparator value.
     */
    @Generated
    public String getContentFieldsSeparator() {
        return this.contentFieldsSeparator;
    }

    /**
     * Set the contentFieldsSeparator property: The separator pattern that content fields should use.
     *
     * @param contentFieldsSeparator the contentFieldsSeparator value to set.
     * @return the PineconeFieldMappingOptions object itself.
     */
    @Generated
    public PineconeFieldMappingOptions setContentFieldsSeparator(String contentFieldsSeparator) {
        this.contentFieldsSeparator = contentFieldsSeparator;
        return this;
    }

    /**
     * Creates an instance of PineconeFieldMappingOptions class.
     *
     * @param contentFields the contentFields value to set.
     */
    @Generated
    @JsonCreator
    public PineconeFieldMappingOptions(@JsonProperty(value = "content_fields") List<String> contentFields) {
        this.contentFields = contentFields;
    }
}
