/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.secrets;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.core.util.polling.SyncPoller;
import com.azure.security.keyvault.secrets.SecretAsyncClient;
import com.azure.security.keyvault.secrets.models.DeletedSecret;
import com.azure.security.keyvault.secrets.models.KeyVaultSecret;
import com.azure.security.keyvault.secrets.models.SecretProperties;

public final class SecretClient {
    private final SecretAsyncClient client;

    public String getVaultUrl() {
        return this.client.getVaultUrl();
    }

    SecretClient(SecretAsyncClient client) {
        this.client = client;
    }

    public KeyVaultSecret setSecret(KeyVaultSecret secret) {
        return (KeyVaultSecret)this.setSecretWithResponse(secret, Context.NONE).getValue();
    }

    public KeyVaultSecret setSecret(String name, String value) {
        return (KeyVaultSecret)this.setSecretWithResponse(new KeyVaultSecret(name, value), Context.NONE).getValue();
    }

    public Response<KeyVaultSecret> setSecretWithResponse(KeyVaultSecret secret, Context context) {
        return (Response)this.client.setSecretWithResponse(secret, context).block();
    }

    public KeyVaultSecret getSecret(String name, String version) {
        return (KeyVaultSecret)this.getSecretWithResponse(name, version, Context.NONE).getValue();
    }

    public KeyVaultSecret getSecret(String name) {
        return (KeyVaultSecret)this.getSecretWithResponse(name, "", Context.NONE).getValue();
    }

    public Response<KeyVaultSecret> getSecretWithResponse(String name, String version, Context context) {
        return (Response)this.client.getSecretWithResponse(name, version, context).block();
    }

    public Response<SecretProperties> updateSecretPropertiesWithResponse(SecretProperties secretProperties, Context context) {
        return (Response)this.client.updateSecretPropertiesWithResponse(secretProperties, context).block();
    }

    public SecretProperties updateSecretProperties(SecretProperties secretProperties) {
        return (SecretProperties)this.updateSecretPropertiesWithResponse(secretProperties, Context.NONE).getValue();
    }

    public SyncPoller<DeletedSecret, Void> beginDeleteSecret(String name) {
        return this.client.beginDeleteSecret(name).getSyncPoller();
    }

    public DeletedSecret getDeletedSecret(String name) {
        return (DeletedSecret)this.getDeletedSecretWithResponse(name, Context.NONE).getValue();
    }

    public Response<DeletedSecret> getDeletedSecretWithResponse(String name, Context context) {
        return (Response)this.client.getDeletedSecretWithResponse(name, context).block();
    }

    public void purgeDeletedSecret(String name) {
        this.purgeDeletedSecretWithResponse(name, Context.NONE);
    }

    public Response<Void> purgeDeletedSecretWithResponse(String name, Context context) {
        return (Response)this.client.purgeDeletedSecretWithResponse(name, context).block();
    }

    public SyncPoller<KeyVaultSecret, Void> beginRecoverDeletedSecret(String name) {
        return this.client.beginRecoverDeletedSecret(name).getSyncPoller();
    }

    public byte[] backupSecret(String name) {
        return (byte[])this.backupSecretWithResponse(name, Context.NONE).getValue();
    }

    public Response<byte[]> backupSecretWithResponse(String name, Context context) {
        return (Response)this.client.backupSecretWithResponse(name, context).block();
    }

    public KeyVaultSecret restoreSecretBackup(byte[] backup) {
        return (KeyVaultSecret)this.restoreSecretBackupWithResponse(backup, Context.NONE).getValue();
    }

    public Response<KeyVaultSecret> restoreSecretBackupWithResponse(byte[] backup, Context context) {
        return (Response)this.client.restoreSecretBackupWithResponse(backup, context).block();
    }

    public PagedIterable<SecretProperties> listPropertiesOfSecrets() {
        return this.listPropertiesOfSecrets(Context.NONE);
    }

    public PagedIterable<SecretProperties> listPropertiesOfSecrets(Context context) {
        return new PagedIterable(this.client.listPropertiesOfSecrets(context));
    }

    public PagedIterable<DeletedSecret> listDeletedSecrets(Context context) {
        return new PagedIterable(this.client.listDeletedSecrets(context));
    }

    public PagedIterable<DeletedSecret> listDeletedSecrets() {
        return this.listDeletedSecrets(Context.NONE);
    }

    public PagedIterable<SecretProperties> listPropertiesOfSecretVersions(String name) {
        return this.listPropertiesOfSecretVersions(name, Context.NONE);
    }

    public PagedIterable<SecretProperties> listPropertiesOfSecretVersions(String name, Context context) {
        return new PagedIterable(this.client.listPropertiesOfSecretVersions(name, context));
    }
}

