/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob;

import java.util.Locale;

final class AccountSASPermission {
    private boolean read;
    private boolean add;
    private boolean create;
    private boolean write;
    private boolean delete;
    private boolean list;
    private boolean update;
    private boolean processMessages;

    public static AccountSASPermission parse(String permString) {
        AccountSASPermission permissions = new AccountSASPermission();
        int i = 0;
        while (i < permString.length()) {
            char c = permString.charAt(i);
            switch (c) {
                case 'r': {
                    permissions.read = true;
                    break;
                }
                case 'w': {
                    permissions.write = true;
                    break;
                }
                case 'd': {
                    permissions.delete = true;
                    break;
                }
                case 'l': {
                    permissions.list = true;
                    break;
                }
                case 'a': {
                    permissions.add = true;
                    break;
                }
                case 'c': {
                    permissions.create = true;
                    break;
                }
                case 'u': {
                    permissions.update = true;
                    break;
                }
                case 'p': {
                    permissions.processMessages = true;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format(Locale.ROOT, "%s could not be parsed from '%s' due to invalid value %s.", "Permissions", permString, Character.valueOf(c)));
                }
            }
            ++i;
        }
        return permissions;
    }

    public boolean read() {
        return this.read;
    }

    public AccountSASPermission read(boolean read) {
        this.read = read;
        return this;
    }

    public boolean add() {
        return this.add;
    }

    public AccountSASPermission add(boolean add) {
        this.add = add;
        return this;
    }

    public boolean create() {
        return this.create;
    }

    public AccountSASPermission create(boolean create) {
        this.create = create;
        return this;
    }

    public boolean write() {
        return this.write;
    }

    public AccountSASPermission write(boolean write) {
        this.write = write;
        return this;
    }

    public boolean delete() {
        return this.delete;
    }

    public AccountSASPermission delete(boolean delete) {
        this.delete = delete;
        return this;
    }

    public boolean list() {
        return this.list;
    }

    public AccountSASPermission list(boolean list) {
        this.list = list;
        return this;
    }

    public boolean update() {
        return this.update;
    }

    public AccountSASPermission update(boolean update) {
        this.update = update;
        return this;
    }

    public boolean processMessages() {
        return this.processMessages;
    }

    public AccountSASPermission processMessages(boolean processMessages) {
        this.processMessages = processMessages;
        return this;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.read) {
            builder.append('r');
        }
        if (this.write) {
            builder.append('w');
        }
        if (this.delete) {
            builder.append('d');
        }
        if (this.list) {
            builder.append('l');
        }
        if (this.add) {
            builder.append('a');
        }
        if (this.create) {
            builder.append('c');
        }
        if (this.update) {
            builder.append('u');
        }
        if (this.processMessages) {
            builder.append('p');
        }
        return builder.toString();
    }
}

