/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob;

import java.util.Locale;

final class AccountSASResourceType {
    private boolean service;
    private boolean container;
    private boolean object;

    public static AccountSASResourceType parse(String resourceTypesString) {
        AccountSASResourceType resourceType = new AccountSASResourceType();
        int i = 0;
        while (i < resourceTypesString.length()) {
            char c = resourceTypesString.charAt(i);
            switch (c) {
                case 's': {
                    resourceType.service = true;
                    break;
                }
                case 'c': {
                    resourceType.container = true;
                    break;
                }
                case 'o': {
                    resourceType.object = true;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format(Locale.ROOT, "%s could not be parsed from '%s' due to invalid value %s.", "Resource Types", resourceTypesString, Character.valueOf(c)));
                }
            }
            ++i;
        }
        return resourceType;
    }

    public boolean service() {
        return this.service;
    }

    public AccountSASResourceType service(boolean service) {
        this.service = service;
        return this;
    }

    public boolean container() {
        return this.container;
    }

    public AccountSASResourceType container(boolean container) {
        this.container = container;
        return this;
    }

    public boolean object() {
        return this.object;
    }

    public AccountSASResourceType object(boolean object) {
        this.object = object;
        return this;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.service) {
            builder.append('s');
        }
        if (this.container) {
            builder.append('c');
        }
        if (this.object) {
            builder.append('o');
        }
        return builder.toString();
    }
}

