/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob;

import com.azure.storage.blob.AccountSASPermission;
import com.azure.storage.blob.IPRange;
import com.azure.storage.blob.SASProtocol;
import com.azure.storage.blob.SASQueryParameters;
import com.azure.storage.blob.Utility;
import com.azure.storage.common.credentials.SharedKeyCredential;
import java.security.InvalidKeyException;
import java.time.OffsetDateTime;

final class AccountSASSignatureValues {
    private String version = "2018-11-09";
    private SASProtocol protocol;
    private OffsetDateTime startTime;
    private OffsetDateTime expiryTime;
    private String permissions;
    private IPRange ipRange;
    private String services;
    private String resourceTypes;

    public String version() {
        return this.version;
    }

    public AccountSASSignatureValues version(String version) {
        this.version = version;
        return this;
    }

    public SASProtocol protocol() {
        return this.protocol;
    }

    public AccountSASSignatureValues protocol(SASProtocol protocol) {
        this.protocol = protocol;
        return this;
    }

    public OffsetDateTime startTime() {
        return this.startTime;
    }

    public AccountSASSignatureValues startTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    public OffsetDateTime expiryTime() {
        return this.expiryTime;
    }

    public AccountSASSignatureValues expiryTime(OffsetDateTime expiryTime) {
        this.expiryTime = expiryTime;
        return this;
    }

    public String permissions() {
        return this.permissions;
    }

    public AccountSASSignatureValues permissions(String permissions) {
        this.permissions = permissions;
        return this;
    }

    public IPRange ipRange() {
        return this.ipRange;
    }

    public AccountSASSignatureValues ipRange(IPRange ipRange) {
        this.ipRange = ipRange;
        return this;
    }

    public String services() {
        return this.services;
    }

    public AccountSASSignatureValues services(String services) {
        this.services = services;
        return this;
    }

    public String resourceTypes() {
        return this.resourceTypes;
    }

    public AccountSASSignatureValues resourceTypes(String resourceTypes) {
        this.resourceTypes = resourceTypes;
        return this;
    }

    public SASQueryParameters generateSASQueryParameters(SharedKeyCredential sharedKeyCredentials) {
        String signature;
        Utility.assertNotNull("SharedKeyCredential", sharedKeyCredentials);
        Utility.assertNotNull("services", this.services);
        Utility.assertNotNull("resourceTypes", this.resourceTypes);
        Utility.assertNotNull("expiryTime", this.expiryTime);
        Utility.assertNotNull("permissions", this.permissions);
        Utility.assertNotNull("version", this.version);
        String stringToSign = this.stringToSign(sharedKeyCredentials);
        try {
            signature = sharedKeyCredentials.computeHmac256(stringToSign);
        }
        catch (InvalidKeyException e) {
            throw new Error(e);
        }
        return new SASQueryParameters(this.version, this.services, this.resourceTypes, this.protocol, this.startTime, this.expiryTime, this.ipRange, null, null, this.permissions, signature, null, null, null, null, null, null);
    }

    private String stringToSign(SharedKeyCredential sharedKeyCredentials) {
        return String.join((CharSequence)"\n", sharedKeyCredentials.accountName(), AccountSASPermission.parse(this.permissions).toString(), this.services, this.resourceTypes, this.startTime == null ? "" : Utility.ISO_8601_UTC_DATE_FORMATTER.format(this.startTime), Utility.ISO_8601_UTC_DATE_FORMATTER.format(this.expiryTime), this.ipRange == null ? new IPRange().toString() : this.ipRange.toString(), this.protocol == null ? "" : this.protocol.toString(), this.version, "");
    }
}

