/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.storage.blob.AppendBlobAsyncRawClient;
import com.azure.storage.blob.AppendBlobClientBuilder;
import com.azure.storage.blob.BlobAsyncClient;
import com.azure.storage.blob.implementation.AzureBlobStorageBuilder;
import com.azure.storage.blob.models.AppendBlobAccessConditions;
import com.azure.storage.blob.models.AppendBlobAppendBlockFromUrlHeaders;
import com.azure.storage.blob.models.AppendBlobAppendBlockHeaders;
import com.azure.storage.blob.models.AppendBlobCreateHeaders;
import com.azure.storage.blob.models.AppendBlobItem;
import com.azure.storage.blob.models.BlobAccessConditions;
import com.azure.storage.blob.models.BlobHTTPHeaders;
import com.azure.storage.blob.models.BlobRange;
import com.azure.storage.blob.models.Metadata;
import com.azure.storage.blob.models.SourceModifiedAccessConditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.net.URL;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class AppendBlobAsyncClient
extends BlobAsyncClient {
    final AppendBlobAsyncRawClient appendBlobAsyncRawClient;
    public static final int MAX_APPEND_BLOCK_BYTES = 0x400000;
    public static final int MAX_BLOCKS = 50000;

    AppendBlobAsyncClient(AzureBlobStorageBuilder azureBlobStorageBuilder, String snapshot) {
        super(azureBlobStorageBuilder, snapshot);
        this.appendBlobAsyncRawClient = new AppendBlobAsyncRawClient(azureBlobStorageBuilder.build());
    }

    public static AppendBlobClientBuilder appendBlobClientBuilder() {
        return new AppendBlobClientBuilder();
    }

    public Mono<Response<AppendBlobItem>> create() {
        return this.create(null, null, null);
    }

    public Mono<Response<AppendBlobItem>> create(BlobHTTPHeaders headers, Metadata metadata, BlobAccessConditions accessConditions) {
        return this.appendBlobAsyncRawClient.create(headers, metadata, accessConditions).map(rb -> new SimpleResponse((Response)rb, (Object)new AppendBlobItem((AppendBlobCreateHeaders)rb.deserializedHeaders())));
    }

    public Mono<Response<AppendBlobItem>> appendBlock(Flux<ByteBuffer> data, long length) {
        return this.appendBlock(data, length, null);
    }

    public Mono<Response<AppendBlobItem>> appendBlock(Flux<ByteBuffer> data, long length, AppendBlobAccessConditions appendBlobAccessConditions) {
        return this.appendBlobAsyncRawClient.appendBlock((Flux<ByteBuf>)data.map(Unpooled::wrappedBuffer), length, appendBlobAccessConditions).map(rb -> new SimpleResponse((Response)rb, (Object)new AppendBlobItem((AppendBlobAppendBlockHeaders)rb.deserializedHeaders())));
    }

    public Mono<Response<AppendBlobItem>> appendBlockFromUrl(URL sourceURL, BlobRange sourceRange) {
        return this.appendBlockFromUrl(sourceURL, sourceRange, null, null, null);
    }

    public Mono<Response<AppendBlobItem>> appendBlockFromUrl(URL sourceURL, BlobRange sourceRange, byte[] sourceContentMD5, AppendBlobAccessConditions destAccessConditions, SourceModifiedAccessConditions sourceAccessConditions) {
        return this.appendBlobAsyncRawClient.appendBlockFromUrl(sourceURL, sourceRange, sourceContentMD5, destAccessConditions, sourceAccessConditions).map(rb -> new SimpleResponse((Response)rb, (Object)new AppendBlobItem((AppendBlobAppendBlockFromUrlHeaders)rb.deserializedHeaders())));
    }
}

