/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob;

import com.azure.core.util.Context;
import com.azure.storage.blob.BlobAsyncRawClient;
import com.azure.storage.blob.Utility;
import com.azure.storage.blob.implementation.AzureBlobStorageImpl;
import com.azure.storage.blob.models.AppendBlobAccessConditions;
import com.azure.storage.blob.models.AppendBlobsAppendBlockFromUrlResponse;
import com.azure.storage.blob.models.AppendBlobsAppendBlockResponse;
import com.azure.storage.blob.models.AppendBlobsCreateResponse;
import com.azure.storage.blob.models.BlobAccessConditions;
import com.azure.storage.blob.models.BlobHTTPHeaders;
import com.azure.storage.blob.models.BlobRange;
import com.azure.storage.blob.models.Metadata;
import com.azure.storage.blob.models.SourceModifiedAccessConditions;
import io.netty.buffer.ByteBuf;
import java.net.URL;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

final class AppendBlobAsyncRawClient
extends BlobAsyncRawClient {
    public static final int MAX_APPEND_BLOCK_BYTES = 0x400000;
    public static final int MAX_BLOCKS = 50000;

    AppendBlobAsyncRawClient(AzureBlobStorageImpl azureBlobStorage) {
        super(azureBlobStorage, null);
    }

    public Mono<AppendBlobsCreateResponse> create() {
        return this.create(null, null, null);
    }

    public Mono<AppendBlobsCreateResponse> create(BlobHTTPHeaders headers, Metadata metadata, BlobAccessConditions accessConditions) {
        metadata = metadata == null ? new Metadata() : metadata;
        accessConditions = accessConditions == null ? new BlobAccessConditions() : accessConditions;
        return Utility.postProcessResponse(this.azureBlobStorage.appendBlobs().createWithRestResponseAsync(null, null, 0L, null, metadata, null, null, null, null, headers, accessConditions.leaseAccessConditions(), accessConditions.modifiedAccessConditions(), Context.NONE));
    }

    public Mono<AppendBlobsAppendBlockResponse> appendBlock(Flux<ByteBuf> data, long length) {
        return this.appendBlock(data, length, null);
    }

    public Mono<AppendBlobsAppendBlockResponse> appendBlock(Flux<ByteBuf> data, long length, AppendBlobAccessConditions appendBlobAccessConditions) {
        appendBlobAccessConditions = appendBlobAccessConditions == null ? new AppendBlobAccessConditions() : appendBlobAccessConditions;
        return Utility.postProcessResponse(this.azureBlobStorage.appendBlobs().appendBlockWithRestResponseAsync(null, null, data, length, null, null, null, null, null, null, appendBlobAccessConditions.leaseAccessConditions(), appendBlobAccessConditions.appendPositionAccessConditions(), appendBlobAccessConditions.modifiedAccessConditions(), Context.NONE));
    }

    public Mono<AppendBlobsAppendBlockFromUrlResponse> appendBlockFromUrl(URL sourceURL, BlobRange sourceRange) {
        return this.appendBlockFromUrl(sourceURL, sourceRange, null, null, null);
    }

    public Mono<AppendBlobsAppendBlockFromUrlResponse> appendBlockFromUrl(URL sourceURL, BlobRange sourceRange, byte[] sourceContentMD5, AppendBlobAccessConditions destAccessConditions, SourceModifiedAccessConditions sourceAccessConditions) {
        sourceRange = sourceRange == null ? new BlobRange(0L) : sourceRange;
        destAccessConditions = destAccessConditions == null ? new AppendBlobAccessConditions() : destAccessConditions;
        return Utility.postProcessResponse(this.azureBlobStorage.appendBlobs().appendBlockFromUrlWithRestResponseAsync(null, null, sourceURL, 0L, sourceRange.toString(), sourceContentMD5, null, null, destAccessConditions.leaseAccessConditions(), destAccessConditions.appendPositionAccessConditions(), destAccessConditions.modifiedAccessConditions(), sourceAccessConditions, Context.NONE));
    }
}

