/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob;

import com.azure.core.http.rest.Response;
import com.azure.storage.blob.AppendBlobAsyncClient;
import com.azure.storage.blob.AppendBlobClientBuilder;
import com.azure.storage.blob.BlobClient;
import com.azure.storage.blob.BlobOutputStream;
import com.azure.storage.blob.Utility;
import com.azure.storage.blob.models.AppendBlobAccessConditions;
import com.azure.storage.blob.models.AppendBlobItem;
import com.azure.storage.blob.models.BlobAccessConditions;
import com.azure.storage.blob.models.BlobHTTPHeaders;
import com.azure.storage.blob.models.BlobRange;
import com.azure.storage.blob.models.Metadata;
import com.azure.storage.blob.models.SourceModifiedAccessConditions;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.time.Duration;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public final class AppendBlobClient
extends BlobClient {
    AppendBlobAsyncClient appendBlobAsyncClient;
    public static final int MAX_APPEND_BLOCK_BYTES = 0x400000;
    public static final int MAX_BLOCKS = 50000;

    AppendBlobClient(AppendBlobAsyncClient appendBlobAsyncClient) {
        super(appendBlobAsyncClient);
        this.appendBlobAsyncClient = appendBlobAsyncClient;
    }

    public static AppendBlobClientBuilder appendBlobClientBuilder() {
        return new AppendBlobClientBuilder();
    }

    public BlobOutputStream getBlobOutputStream() {
        return this.getBlobOutputStream(null);
    }

    public BlobOutputStream getBlobOutputStream(AppendBlobAccessConditions accessConditions) {
        return new BlobOutputStream(this.appendBlobAsyncClient, accessConditions);
    }

    public Response<AppendBlobItem> create() {
        return this.create(null, null, null, null);
    }

    public Response<AppendBlobItem> create(BlobHTTPHeaders headers, Metadata metadata, BlobAccessConditions accessConditions, Duration timeout) {
        Mono<Response<AppendBlobItem>> response = this.appendBlobAsyncClient.create(headers, metadata, accessConditions);
        return Utility.blockWithOptionalTimeout(response, timeout);
    }

    public Response<AppendBlobItem> appendBlock(InputStream data, long length) {
        return this.appendBlock(data, length, null, null);
    }

    public Response<AppendBlobItem> appendBlock(InputStream data, long length, AppendBlobAccessConditions appendBlobAccessConditions, Duration timeout) {
        Flux fbb = Flux.range((int)0, (int)((int)Math.ceil((double)length / 4194304.0))).map(i -> i * 0x400000).concatMap(pos -> Mono.fromCallable(() -> {
            long count = (long)(pos + 0x400000) > length ? length - (long)pos.intValue() : 0x400000L;
            byte[] cache = new byte[(int)count];
            int read = 0;
            while ((long)read < count) {
                read += data.read(cache, read, (int)count - read);
            }
            return ByteBuffer.wrap(cache);
        }));
        Mono<Response<AppendBlobItem>> response = this.appendBlobAsyncClient.appendBlock((Flux<ByteBuffer>)fbb.subscribeOn(Schedulers.elastic()), length, appendBlobAccessConditions);
        return Utility.blockWithOptionalTimeout(response, timeout);
    }

    public Response<AppendBlobItem> appendBlockFromUrl(URL sourceURL, BlobRange sourceRange) {
        return this.appendBlockFromUrl(sourceURL, sourceRange, null, null, null, null);
    }

    public Response<AppendBlobItem> appendBlockFromUrl(URL sourceURL, BlobRange sourceRange, byte[] sourceContentMD5, AppendBlobAccessConditions destAccessConditions, SourceModifiedAccessConditions sourceAccessConditions, Duration timeout) {
        Mono<Response<AppendBlobItem>> response = this.appendBlobAsyncClient.appendBlockFromUrl(sourceURL, sourceRange, sourceContentMD5, destAccessConditions, sourceAccessConditions);
        return Utility.blockWithOptionalTimeout(response, timeout);
    }
}

