/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob;

import com.azure.core.http.HttpResponse;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.http.rest.VoidResponse;
import com.azure.core.implementation.http.UrlBuilder;
import com.azure.core.implementation.util.FluxUtil;
import com.azure.storage.blob.AppendBlobAsyncClient;
import com.azure.storage.blob.BlobAsyncRawClient;
import com.azure.storage.blob.BlobClientBuilder;
import com.azure.storage.blob.BlobProperties;
import com.azure.storage.blob.BlobURLParts;
import com.azure.storage.blob.BlockBlobAsyncClient;
import com.azure.storage.blob.ContainerAsyncClient;
import com.azure.storage.blob.PageBlobAsyncClient;
import com.azure.storage.blob.StorageException;
import com.azure.storage.blob.URLParser;
import com.azure.storage.blob.implementation.AzureBlobStorageBuilder;
import com.azure.storage.blob.models.AccessTier;
import com.azure.storage.blob.models.BlobAccessConditions;
import com.azure.storage.blob.models.BlobAcquireLeaseHeaders;
import com.azure.storage.blob.models.BlobBreakLeaseHeaders;
import com.azure.storage.blob.models.BlobChangeLeaseHeaders;
import com.azure.storage.blob.models.BlobCopyFromURLHeaders;
import com.azure.storage.blob.models.BlobCreateSnapshotHeaders;
import com.azure.storage.blob.models.BlobGetAccountInfoHeaders;
import com.azure.storage.blob.models.BlobGetPropertiesHeaders;
import com.azure.storage.blob.models.BlobHTTPHeaders;
import com.azure.storage.blob.models.BlobRange;
import com.azure.storage.blob.models.BlobRenewLeaseHeaders;
import com.azure.storage.blob.models.BlobStartCopyFromURLHeaders;
import com.azure.storage.blob.models.DeleteSnapshotsOptionType;
import com.azure.storage.blob.models.LeaseAccessConditions;
import com.azure.storage.blob.models.Metadata;
import com.azure.storage.blob.models.ModifiedAccessConditions;
import com.azure.storage.blob.models.ReliableDownloadOptions;
import com.azure.storage.blob.models.StorageAccountInfo;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class BlobAsyncClient {
    private static final int BLOB_DEFAULT_DOWNLOAD_BLOCK_SIZE = 0x400000;
    private static final int BLOB_MAX_DOWNLOAD_BLOCK_SIZE = 0x6400000;
    final BlobAsyncRawClient blobAsyncRawClient;

    BlobAsyncClient(AzureBlobStorageBuilder azureBlobStorageBuilder, String snapshot) {
        this.blobAsyncRawClient = new BlobAsyncRawClient(azureBlobStorageBuilder.build(), snapshot);
    }

    public static BlobClientBuilder blobClientBuilder() {
        return new BlobClientBuilder();
    }

    public BlockBlobAsyncClient asBlockBlobAsyncClient() {
        return new BlockBlobAsyncClient(new AzureBlobStorageBuilder().url(this.getBlobUrl().toString()).pipeline(this.blobAsyncRawClient.azureBlobStorage.httpPipeline()), this.blobAsyncRawClient.snapshot);
    }

    public AppendBlobAsyncClient asAppendBlobAsyncClient() {
        return new AppendBlobAsyncClient(new AzureBlobStorageBuilder().url(this.getBlobUrl().toString()).pipeline(this.blobAsyncRawClient.azureBlobStorage.httpPipeline()), this.blobAsyncRawClient.snapshot);
    }

    public PageBlobAsyncClient asPageBlobAsyncClient() {
        return new PageBlobAsyncClient(new AzureBlobStorageBuilder().url(this.getBlobUrl().toString()).pipeline(this.blobAsyncRawClient.azureBlobStorage.httpPipeline()), this.blobAsyncRawClient.snapshot);
    }

    public ContainerAsyncClient getContainerAsyncClient() {
        try {
            BlobURLParts parts = URLParser.parse(this.getBlobUrl());
            return new ContainerAsyncClient(new AzureBlobStorageBuilder().url(String.format("%s://%s/%s", parts.scheme(), parts.host(), parts.containerName())).pipeline(this.blobAsyncRawClient.azureBlobStorage.httpPipeline()));
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    public URL getBlobUrl() {
        try {
            UrlBuilder urlBuilder = UrlBuilder.parse((String)this.blobAsyncRawClient.azureBlobStorage.url());
            if (this.blobAsyncRawClient.snapshot != null) {
                urlBuilder.query("snapshot=" + this.blobAsyncRawClient.snapshot);
            }
            return urlBuilder.toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(String.format("Invalid URL on %s: %s" + this.getClass().getSimpleName(), this.blobAsyncRawClient.azureBlobStorage.url()), e);
        }
    }

    public Mono<Response<Boolean>> exists() {
        return this.getProperties().map(cp -> new SimpleResponse(cp, (Object)true)).onErrorResume(t -> t instanceof StorageException && ((StorageException)((Object)((Object)t))).statusCode() == 404, t -> {
            HttpResponse response = ((StorageException)((Object)((Object)t))).response();
            return Mono.just((Object)new SimpleResponse(response.request(), response.statusCode(), response.headers(), (Object)false));
        });
    }

    public Mono<Response<String>> startCopyFromURL(URL sourceURL) {
        return this.startCopyFromURL(sourceURL, null, null, null);
    }

    public Mono<Response<String>> startCopyFromURL(URL sourceURL, Metadata metadata, ModifiedAccessConditions sourceModifiedAccessConditions, BlobAccessConditions destAccessConditions) {
        return this.blobAsyncRawClient.startCopyFromURL(sourceURL, metadata, sourceModifiedAccessConditions, destAccessConditions).map(rb -> new SimpleResponse((Response)rb, (Object)((BlobStartCopyFromURLHeaders)rb.deserializedHeaders()).copyId()));
    }

    public Mono<VoidResponse> abortCopyFromURL(String copyId) {
        return this.abortCopyFromURL(copyId, null);
    }

    public Mono<VoidResponse> abortCopyFromURL(String copyId, LeaseAccessConditions leaseAccessConditions) {
        return this.blobAsyncRawClient.abortCopyFromURL(copyId, leaseAccessConditions).map(VoidResponse::new);
    }

    public Mono<Response<String>> copyFromURL(URL copySource) {
        return this.copyFromURL(copySource, null, null, null);
    }

    public Mono<Response<String>> copyFromURL(URL copySource, Metadata metadata, ModifiedAccessConditions sourceModifiedAccessConditions, BlobAccessConditions destAccessConditions) {
        return this.blobAsyncRawClient.syncCopyFromURL(copySource, metadata, sourceModifiedAccessConditions, destAccessConditions).map(rb -> new SimpleResponse((Response)rb, (Object)((BlobCopyFromURLHeaders)rb.deserializedHeaders()).copyId()));
    }

    public Mono<Response<Flux<ByteBuffer>>> download() {
        return this.download(null, null, false, null);
    }

    public Mono<Response<Flux<ByteBuffer>>> download(BlobRange range, BlobAccessConditions accessConditions, boolean rangeGetContentMD5, ReliableDownloadOptions options) {
        return this.blobAsyncRawClient.download(range, accessConditions, rangeGetContentMD5).map(response -> new SimpleResponse(response.rawResponse(), (Object)response.body(options).map(ByteBuf::nioBuffer).switchIfEmpty((Publisher)Flux.just((Object)ByteBuffer.allocate(0)))));
    }

    public Mono<Void> downloadToFile(String filePath) {
        return this.downloadToFile(filePath, null, 0x400000, null, false, null);
    }

    public Mono<Void> downloadToFile(String filePath, BlobRange range, Integer blockSize, BlobAccessConditions accessConditions, boolean rangeGetContentMD5, ReliableDownloadOptions options) {
        if (blockSize < 0 || blockSize > 0x6400000) {
            throw new IllegalArgumentException("Block size should not exceed 100MB");
        }
        return Mono.using(() -> {
            try {
                return AsynchronousFileChannel.open(Paths.get(filePath, new String[0]), StandardOpenOption.READ, StandardOpenOption.WRITE);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }, channel -> Mono.justOrEmpty((Object)range).switchIfEmpty(this.getFullBlobRange(accessConditions)).flatMapMany(rg -> Flux.fromIterable(this.sliceBlobRange((BlobRange)rg, blockSize))).flatMap(chunk -> this.blobAsyncRawClient.download((BlobRange)chunk, accessConditions, rangeGetContentMD5).subscribeOn(Schedulers.elastic()).flatMap(dar -> FluxUtil.bytebufStreamToFile(dar.body(options), (AsynchronousFileChannel)channel, (long)(chunk.offset() - (range == null ? 0L : range.offset()))))).then(), channel -> {
            try {
                channel.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
    }

    private Mono<BlobRange> getFullBlobRange(BlobAccessConditions accessConditions) {
        return this.getProperties(accessConditions).map(rb -> new BlobRange(0L, ((BlobProperties)rb.value()).blobSize()));
    }

    private List<BlobRange> sliceBlobRange(BlobRange blobRange, Integer blockSize) {
        if (blockSize == null) {
            blockSize = 0x400000;
        }
        long offset = blobRange.offset();
        long length = blobRange.count();
        ArrayList<BlobRange> chunks = new ArrayList<BlobRange>();
        long pos = offset;
        while (pos < offset + length) {
            long count = blockSize.intValue();
            if (pos + count > offset + length) {
                count = offset + length - pos;
            }
            chunks.add(new BlobRange(pos, count));
            pos += (long)blockSize.intValue();
        }
        return chunks;
    }

    public Mono<VoidResponse> delete() {
        return this.delete(null, null);
    }

    public Mono<VoidResponse> delete(DeleteSnapshotsOptionType deleteBlobSnapshotOptions, BlobAccessConditions accessConditions) {
        return this.blobAsyncRawClient.delete(deleteBlobSnapshotOptions, accessConditions).map(VoidResponse::new);
    }

    public Mono<Response<BlobProperties>> getProperties() {
        return this.getProperties(null);
    }

    public Mono<Response<BlobProperties>> getProperties(BlobAccessConditions accessConditions) {
        return this.blobAsyncRawClient.getProperties(accessConditions).map(rb -> new SimpleResponse((Response)rb, (Object)new BlobProperties((BlobGetPropertiesHeaders)rb.deserializedHeaders())));
    }

    public Mono<VoidResponse> setHTTPHeaders(BlobHTTPHeaders headers) {
        return this.setHTTPHeaders(headers, null);
    }

    public Mono<VoidResponse> setHTTPHeaders(BlobHTTPHeaders headers, BlobAccessConditions accessConditions) {
        return this.blobAsyncRawClient.setHTTPHeaders(headers, accessConditions).map(VoidResponse::new);
    }

    public Mono<VoidResponse> setMetadata(Metadata metadata) {
        return this.setMetadata(metadata, null);
    }

    public Mono<VoidResponse> setMetadata(Metadata metadata, BlobAccessConditions accessConditions) {
        return this.blobAsyncRawClient.setMetadata(metadata, accessConditions).map(VoidResponse::new);
    }

    public Mono<Response<String>> createSnapshot() {
        return this.createSnapshot(null, null);
    }

    public Mono<Response<String>> createSnapshot(Metadata metadata, BlobAccessConditions accessConditions) {
        return this.blobAsyncRawClient.createSnapshot(metadata, accessConditions).map(rb -> new SimpleResponse((Response)rb, (Object)((BlobCreateSnapshotHeaders)rb.deserializedHeaders()).snapshot()));
    }

    public Mono<VoidResponse> setTier(AccessTier tier) {
        return this.setTier(tier, null);
    }

    public Mono<VoidResponse> setTier(AccessTier tier, LeaseAccessConditions leaseAccessConditions) {
        return this.blobAsyncRawClient.setTier(tier, leaseAccessConditions).map(VoidResponse::new);
    }

    public Mono<VoidResponse> undelete() {
        return this.blobAsyncRawClient.undelete().map(VoidResponse::new);
    }

    public Mono<Response<String>> acquireLease(String proposedId, int duration) {
        return this.acquireLease(proposedId, duration, null);
    }

    public Mono<Response<String>> acquireLease(String proposedID, int duration, ModifiedAccessConditions modifiedAccessConditions) {
        return this.blobAsyncRawClient.acquireLease(proposedID, duration, modifiedAccessConditions).map(rb -> new SimpleResponse((Response)rb, (Object)((BlobAcquireLeaseHeaders)rb.deserializedHeaders()).leaseId()));
    }

    public Mono<Response<String>> renewLease(String leaseID) {
        return this.renewLease(leaseID, null);
    }

    public Mono<Response<String>> renewLease(String leaseID, ModifiedAccessConditions modifiedAccessConditions) {
        return this.blobAsyncRawClient.renewLease(leaseID, modifiedAccessConditions).map(rb -> new SimpleResponse((Response)rb, (Object)((BlobRenewLeaseHeaders)rb.deserializedHeaders()).leaseId()));
    }

    public Mono<VoidResponse> releaseLease(String leaseID) {
        return this.releaseLease(leaseID, null);
    }

    public Mono<VoidResponse> releaseLease(String leaseID, ModifiedAccessConditions modifiedAccessConditions) {
        return this.blobAsyncRawClient.releaseLease(leaseID, modifiedAccessConditions).map(VoidResponse::new);
    }

    public Mono<Response<Integer>> breakLease() {
        return this.breakLease(null, null);
    }

    public Mono<Response<Integer>> breakLease(Integer breakPeriodInSeconds, ModifiedAccessConditions modifiedAccessConditions) {
        return this.blobAsyncRawClient.breakLease(breakPeriodInSeconds, modifiedAccessConditions).map(rb -> new SimpleResponse((Response)rb, (Object)((BlobBreakLeaseHeaders)rb.deserializedHeaders()).leaseTime()));
    }

    public Mono<Response<String>> changeLease(String leaseId, String proposedID) {
        return this.changeLease(leaseId, proposedID, null);
    }

    public Mono<Response<String>> changeLease(String leaseId, String proposedID, ModifiedAccessConditions modifiedAccessConditions) {
        return this.blobAsyncRawClient.changeLease(leaseId, proposedID, modifiedAccessConditions).map(rb -> new SimpleResponse((Response)rb, (Object)((BlobChangeLeaseHeaders)rb.deserializedHeaders()).leaseId()));
    }

    public Mono<Response<StorageAccountInfo>> getAccountInfo() {
        return this.blobAsyncRawClient.getAccountInfo().map(rb -> new SimpleResponse((Response)rb, (Object)new StorageAccountInfo((BlobGetAccountInfoHeaders)rb.deserializedHeaders())));
    }
}

