/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob;

import com.azure.core.http.rest.ResponseBase;
import com.azure.core.util.Context;
import com.azure.storage.blob.DownloadAsyncResponse;
import com.azure.storage.blob.HTTPGetterInfo;
import com.azure.storage.blob.Utility;
import com.azure.storage.blob.implementation.AzureBlobStorageImpl;
import com.azure.storage.blob.models.AccessTier;
import com.azure.storage.blob.models.BlobAccessConditions;
import com.azure.storage.blob.models.BlobDownloadHeaders;
import com.azure.storage.blob.models.BlobHTTPHeaders;
import com.azure.storage.blob.models.BlobRange;
import com.azure.storage.blob.models.BlobsAbortCopyFromURLResponse;
import com.azure.storage.blob.models.BlobsAcquireLeaseResponse;
import com.azure.storage.blob.models.BlobsBreakLeaseResponse;
import com.azure.storage.blob.models.BlobsChangeLeaseResponse;
import com.azure.storage.blob.models.BlobsCopyFromURLResponse;
import com.azure.storage.blob.models.BlobsCreateSnapshotResponse;
import com.azure.storage.blob.models.BlobsDeleteResponse;
import com.azure.storage.blob.models.BlobsGetAccountInfoResponse;
import com.azure.storage.blob.models.BlobsGetPropertiesResponse;
import com.azure.storage.blob.models.BlobsReleaseLeaseResponse;
import com.azure.storage.blob.models.BlobsRenewLeaseResponse;
import com.azure.storage.blob.models.BlobsSetHTTPHeadersResponse;
import com.azure.storage.blob.models.BlobsSetMetadataResponse;
import com.azure.storage.blob.models.BlobsSetTierResponse;
import com.azure.storage.blob.models.BlobsStartCopyFromURLResponse;
import com.azure.storage.blob.models.BlobsUndeleteResponse;
import com.azure.storage.blob.models.DeleteSnapshotsOptionType;
import com.azure.storage.blob.models.LeaseAccessConditions;
import com.azure.storage.blob.models.Metadata;
import com.azure.storage.blob.models.ModifiedAccessConditions;
import com.azure.storage.blob.models.SourceModifiedAccessConditions;
import io.netty.buffer.ByteBuf;
import java.net.URL;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class BlobAsyncRawClient {
    protected AzureBlobStorageImpl azureBlobStorage;
    final String snapshot;

    BlobAsyncRawClient(AzureBlobStorageImpl azureBlobStorage, String snapshot) {
        this.azureBlobStorage = azureBlobStorage;
        this.snapshot = snapshot;
    }

    public Mono<BlobsStartCopyFromURLResponse> startCopyFromURL(URL sourceURL) {
        return this.startCopyFromURL(sourceURL, null, null, null);
    }

    public Mono<BlobsStartCopyFromURLResponse> startCopyFromURL(URL sourceURL, Metadata metadata, ModifiedAccessConditions sourceModifiedAccessConditions, BlobAccessConditions destAccessConditions) {
        metadata = metadata == null ? new Metadata() : metadata;
        sourceModifiedAccessConditions = sourceModifiedAccessConditions == null ? new ModifiedAccessConditions() : sourceModifiedAccessConditions;
        destAccessConditions = destAccessConditions == null ? new BlobAccessConditions() : destAccessConditions;
        SourceModifiedAccessConditions sourceConditions = new SourceModifiedAccessConditions().sourceIfModifiedSince(sourceModifiedAccessConditions.ifModifiedSince()).sourceIfUnmodifiedSince(sourceModifiedAccessConditions.ifUnmodifiedSince()).sourceIfMatch(sourceModifiedAccessConditions.ifMatch()).sourceIfNoneMatch(sourceModifiedAccessConditions.ifNoneMatch());
        return Utility.postProcessResponse(this.azureBlobStorage.blobs().startCopyFromURLWithRestResponseAsync(null, null, sourceURL, null, metadata, null, sourceConditions, destAccessConditions.modifiedAccessConditions(), destAccessConditions.leaseAccessConditions(), Context.NONE));
    }

    public Mono<BlobsAbortCopyFromURLResponse> abortCopyFromURL(String copyId) {
        return this.abortCopyFromURL(copyId, null);
    }

    public Mono<BlobsAbortCopyFromURLResponse> abortCopyFromURL(String copyId, LeaseAccessConditions leaseAccessConditions) {
        return Utility.postProcessResponse(this.azureBlobStorage.blobs().abortCopyFromURLWithRestResponseAsync(null, null, copyId, null, null, leaseAccessConditions, Context.NONE));
    }

    public Mono<BlobsCopyFromURLResponse> syncCopyFromURL(URL copySource) {
        return this.syncCopyFromURL(copySource, null, null, null);
    }

    public Mono<BlobsCopyFromURLResponse> syncCopyFromURL(URL copySource, Metadata metadata, ModifiedAccessConditions sourceModifiedAccessConditions, BlobAccessConditions destAccessConditions) {
        metadata = metadata == null ? new Metadata() : metadata;
        sourceModifiedAccessConditions = sourceModifiedAccessConditions == null ? new ModifiedAccessConditions() : sourceModifiedAccessConditions;
        destAccessConditions = destAccessConditions == null ? new BlobAccessConditions() : destAccessConditions;
        SourceModifiedAccessConditions sourceConditions = new SourceModifiedAccessConditions().sourceIfModifiedSince(sourceModifiedAccessConditions.ifModifiedSince()).sourceIfUnmodifiedSince(sourceModifiedAccessConditions.ifUnmodifiedSince()).sourceIfMatch(sourceModifiedAccessConditions.ifMatch()).sourceIfNoneMatch(sourceModifiedAccessConditions.ifNoneMatch());
        return Utility.postProcessResponse(this.azureBlobStorage.blobs().copyFromURLWithRestResponseAsync(null, null, copySource, null, metadata, null, sourceConditions, destAccessConditions.modifiedAccessConditions(), destAccessConditions.leaseAccessConditions(), Context.NONE));
    }

    public Mono<DownloadAsyncResponse> download() {
        return this.download(null, null, false);
    }

    public Mono<DownloadAsyncResponse> download(BlobRange range, BlobAccessConditions accessConditions, boolean rangeGetContentMD5) {
        range = range == null ? new BlobRange(0L) : range;
        Boolean getMD5 = rangeGetContentMD5 ? Boolean.valueOf(rangeGetContentMD5) : null;
        accessConditions = accessConditions == null ? new BlobAccessConditions() : accessConditions;
        HTTPGetterInfo info = new HTTPGetterInfo().offset(range.offset()).count(range.count()).eTag(accessConditions.modifiedAccessConditions().ifMatch());
        return Utility.postProcessResponse(this.azureBlobStorage.blobs().downloadWithRestResponseAsync(null, null, this.snapshot, null, null, range.toHeaderValue(), getMD5, null, null, null, null, accessConditions.leaseAccessConditions(), accessConditions.modifiedAccessConditions(), Context.NONE)).map(response -> {
            info.eTag(((BlobDownloadHeaders)response.deserializedHeaders()).eTag());
            return new DownloadAsyncResponse((ResponseBase<BlobDownloadHeaders, Flux<ByteBuf>>)response, info, newInfo -> this.download(new BlobRange(newInfo.offset(), newInfo.count()), new BlobAccessConditions().modifiedAccessConditions(new ModifiedAccessConditions().ifMatch(info.eTag())), false));
        });
    }

    public Mono<BlobsDeleteResponse> delete() {
        return this.delete(null, null);
    }

    public Mono<BlobsDeleteResponse> delete(DeleteSnapshotsOptionType deleteBlobSnapshotOptions, BlobAccessConditions accessConditions) {
        accessConditions = accessConditions == null ? new BlobAccessConditions() : accessConditions;
        return Utility.postProcessResponse(this.azureBlobStorage.blobs().deleteWithRestResponseAsync(null, null, this.snapshot, null, null, deleteBlobSnapshotOptions, null, accessConditions.leaseAccessConditions(), accessConditions.modifiedAccessConditions(), Context.NONE));
    }

    public Mono<BlobsGetPropertiesResponse> getProperties() {
        return this.getProperties(null);
    }

    public Mono<BlobsGetPropertiesResponse> getProperties(BlobAccessConditions accessConditions) {
        accessConditions = accessConditions == null ? new BlobAccessConditions() : accessConditions;
        return Utility.postProcessResponse(this.azureBlobStorage.blobs().getPropertiesWithRestResponseAsync(null, null, this.snapshot, null, null, null, null, null, null, accessConditions.leaseAccessConditions(), accessConditions.modifiedAccessConditions(), Context.NONE));
    }

    public Mono<BlobsSetHTTPHeadersResponse> setHTTPHeaders(BlobHTTPHeaders headers) {
        return this.setHTTPHeaders(headers, null);
    }

    public Mono<BlobsSetHTTPHeadersResponse> setHTTPHeaders(BlobHTTPHeaders headers, BlobAccessConditions accessConditions) {
        accessConditions = accessConditions == null ? new BlobAccessConditions() : accessConditions;
        return Utility.postProcessResponse(this.azureBlobStorage.blobs().setHTTPHeadersWithRestResponseAsync(null, null, null, null, headers, accessConditions.leaseAccessConditions(), accessConditions.modifiedAccessConditions(), Context.NONE));
    }

    public Mono<BlobsSetMetadataResponse> setMetadata(Metadata metadata) {
        return this.setMetadata(metadata, null);
    }

    public Mono<BlobsSetMetadataResponse> setMetadata(Metadata metadata, BlobAccessConditions accessConditions) {
        metadata = metadata == null ? new Metadata() : metadata;
        accessConditions = accessConditions == null ? new BlobAccessConditions() : accessConditions;
        return Utility.postProcessResponse(this.azureBlobStorage.blobs().setMetadataWithRestResponseAsync(null, null, null, metadata, null, null, null, null, accessConditions.leaseAccessConditions(), accessConditions.modifiedAccessConditions(), Context.NONE));
    }

    public Mono<BlobsCreateSnapshotResponse> createSnapshot() {
        return this.createSnapshot(null, null);
    }

    public Mono<BlobsCreateSnapshotResponse> createSnapshot(Metadata metadata, BlobAccessConditions accessConditions) {
        metadata = metadata == null ? new Metadata() : metadata;
        accessConditions = accessConditions == null ? new BlobAccessConditions() : accessConditions;
        return Utility.postProcessResponse(this.azureBlobStorage.blobs().createSnapshotWithRestResponseAsync(null, null, null, metadata, null, null, null, null, accessConditions.modifiedAccessConditions(), accessConditions.leaseAccessConditions(), Context.NONE));
    }

    public Mono<BlobsSetTierResponse> setTier(AccessTier tier) {
        return this.setTier(tier, null);
    }

    public Mono<BlobsSetTierResponse> setTier(AccessTier tier, LeaseAccessConditions leaseAccessConditions) {
        Utility.assertNotNull("tier", (Object)tier);
        return Utility.postProcessResponse(this.azureBlobStorage.blobs().setTierWithRestResponseAsync(null, null, tier, null, null, leaseAccessConditions, Context.NONE));
    }

    public Mono<BlobsUndeleteResponse> undelete() {
        return Utility.postProcessResponse(this.azureBlobStorage.blobs().undeleteWithRestResponseAsync(null, null, Context.NONE));
    }

    public Mono<BlobsAcquireLeaseResponse> acquireLease(String proposedId, int duration) {
        return this.acquireLease(proposedId, duration, null);
    }

    public Mono<BlobsAcquireLeaseResponse> acquireLease(String proposedID, int duration, ModifiedAccessConditions modifiedAccessConditions) {
        if (duration != -1 && (duration < 15 || duration > 60)) {
            throw new IllegalArgumentException("Duration must be -1 or between 15 and 60.");
        }
        return Utility.postProcessResponse(this.azureBlobStorage.blobs().acquireLeaseWithRestResponseAsync(null, null, null, duration, proposedID, null, modifiedAccessConditions, Context.NONE));
    }

    public Mono<BlobsRenewLeaseResponse> renewLease(String leaseID) {
        return this.renewLease(leaseID, null);
    }

    public Mono<BlobsRenewLeaseResponse> renewLease(String leaseID, ModifiedAccessConditions modifiedAccessConditions) {
        return Utility.postProcessResponse(this.azureBlobStorage.blobs().renewLeaseWithRestResponseAsync(null, null, leaseID, null, null, modifiedAccessConditions, Context.NONE));
    }

    public Mono<BlobsReleaseLeaseResponse> releaseLease(String leaseID) {
        return this.releaseLease(leaseID, null);
    }

    public Mono<BlobsReleaseLeaseResponse> releaseLease(String leaseID, ModifiedAccessConditions modifiedAccessConditions) {
        return Utility.postProcessResponse(this.azureBlobStorage.blobs().releaseLeaseWithRestResponseAsync(null, null, leaseID, null, null, modifiedAccessConditions, Context.NONE));
    }

    public Mono<BlobsBreakLeaseResponse> breakLease() {
        return this.breakLease(null, null);
    }

    public Mono<BlobsBreakLeaseResponse> breakLease(Integer breakPeriodInSeconds, ModifiedAccessConditions modifiedAccessConditions) {
        return Utility.postProcessResponse(this.azureBlobStorage.blobs().breakLeaseWithRestResponseAsync(null, null, null, breakPeriodInSeconds, null, modifiedAccessConditions, Context.NONE));
    }

    public Mono<BlobsChangeLeaseResponse> changeLease(String leaseId, String proposedID) {
        return this.changeLease(leaseId, proposedID, null);
    }

    public Mono<BlobsChangeLeaseResponse> changeLease(String leaseId, String proposedID, ModifiedAccessConditions modifiedAccessConditions) {
        return Utility.postProcessResponse(this.azureBlobStorage.blobs().changeLeaseWithRestResponseAsync(null, null, leaseId, proposedID, null, null, modifiedAccessConditions, Context.NONE));
    }

    public Mono<BlobsGetAccountInfoResponse> getAccountInfo() {
        return Utility.postProcessResponse(this.azureBlobStorage.blobs().getAccountInfoWithRestResponseAsync(null, null, Context.NONE));
    }
}

