/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.VoidResponse;
import com.azure.storage.blob.AppendBlobClient;
import com.azure.storage.blob.BlobAsyncClient;
import com.azure.storage.blob.BlobClientBuilder;
import com.azure.storage.blob.BlobInputStream;
import com.azure.storage.blob.BlobProperties;
import com.azure.storage.blob.BlockBlobClient;
import com.azure.storage.blob.ContainerClient;
import com.azure.storage.blob.PageBlobClient;
import com.azure.storage.blob.Utility;
import com.azure.storage.blob.models.AccessTier;
import com.azure.storage.blob.models.BlobAccessConditions;
import com.azure.storage.blob.models.BlobHTTPHeaders;
import com.azure.storage.blob.models.BlobRange;
import com.azure.storage.blob.models.DeleteSnapshotsOptionType;
import com.azure.storage.blob.models.LeaseAccessConditions;
import com.azure.storage.blob.models.Metadata;
import com.azure.storage.blob.models.ModifiedAccessConditions;
import com.azure.storage.blob.models.ReliableDownloadOptions;
import com.azure.storage.blob.models.StorageAccountInfo;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.time.Duration;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class BlobClient {
    private static final int BLOB_DEFAULT_DOWNLOAD_BLOCK_SIZE = 0x400000;
    private final BlobAsyncClient blobAsyncClient;

    BlobClient(BlobAsyncClient blobAsyncClient) {
        this.blobAsyncClient = blobAsyncClient;
    }

    public static BlobClientBuilder blobClientBuilder() {
        return new BlobClientBuilder();
    }

    public BlockBlobClient asBlockBlobClient() {
        return new BlockBlobClient(this.blobAsyncClient.asBlockBlobAsyncClient());
    }

    public AppendBlobClient asAppendBlobClient() {
        return new AppendBlobClient(this.blobAsyncClient.asAppendBlobAsyncClient());
    }

    public PageBlobClient asPageBlobClient() {
        return new PageBlobClient(this.blobAsyncClient.asPageBlobAsyncClient());
    }

    public ContainerClient getContainerClient() {
        return new ContainerClient(this.blobAsyncClient.getContainerAsyncClient());
    }

    public URL getBlobUrl() {
        return this.blobAsyncClient.getBlobUrl();
    }

    public final BlobInputStream openInputStream() {
        return this.openInputStream(new BlobRange(0L), null);
    }

    public final BlobInputStream openInputStream(BlobRange range, BlobAccessConditions accessConditions) {
        return new BlobInputStream(this.blobAsyncClient, range.offset(), range.count(), accessConditions);
    }

    public Response<Boolean> exists() {
        return this.exists(null);
    }

    public Response<Boolean> exists(Duration timeout) {
        Mono<Response<Boolean>> response = this.blobAsyncClient.exists();
        return Utility.blockWithOptionalTimeout(response, timeout);
    }

    public Response<String> startCopyFromURL(URL sourceURL) {
        return this.startCopyFromURL(sourceURL, null, null, null, null);
    }

    public Response<String> startCopyFromURL(URL sourceURL, Metadata metadata, ModifiedAccessConditions sourceModifiedAccessConditions, BlobAccessConditions destAccessConditions, Duration timeout) {
        Mono<Response<String>> response = this.blobAsyncClient.startCopyFromURL(sourceURL, metadata, sourceModifiedAccessConditions, destAccessConditions);
        return Utility.blockWithOptionalTimeout(response, timeout);
    }

    public VoidResponse abortCopyFromURL(String copyId) {
        return this.abortCopyFromURL(copyId, null, null);
    }

    public VoidResponse abortCopyFromURL(String copyId, LeaseAccessConditions leaseAccessConditions, Duration timeout) {
        Mono<VoidResponse> response = this.blobAsyncClient.abortCopyFromURL(copyId, leaseAccessConditions);
        return Utility.blockWithOptionalTimeout(response, timeout);
    }

    public Response<String> copyFromURL(URL copySource) {
        return this.copyFromURL(copySource, null, null, null, null);
    }

    public Response<String> copyFromURL(URL copySource, Metadata metadata, ModifiedAccessConditions sourceModifiedAccessConditions, BlobAccessConditions destAccessConditions, Duration timeout) {
        Mono<Response<String>> response = this.blobAsyncClient.copyFromURL(copySource, metadata, sourceModifiedAccessConditions, destAccessConditions);
        return Utility.blockWithOptionalTimeout(response, timeout);
    }

    public VoidResponse download(OutputStream stream) throws IOException {
        return this.download(stream, null, null, null, false, null);
    }

    public VoidResponse download(OutputStream stream, ReliableDownloadOptions options, BlobRange range, BlobAccessConditions accessConditions, boolean rangeGetContentMD5, Duration timeout) throws IOException {
        Mono download = this.blobAsyncClient.download(range, accessConditions, rangeGetContentMD5, options).flatMapMany(res -> ((Flux)res.value()).doOnNext(bf -> {
            try {
                stream.write(bf.array());
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }).map(bf -> res)).last().map(VoidResponse::new);
        try {
            return (VoidResponse)Utility.blockWithOptionalTimeout(download, timeout);
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }

    public void downloadToFile(String filePath) throws IOException {
        this.downloadToFile(filePath, null, null, 0x400000, null, false, null);
    }

    public void downloadToFile(String filePath, ReliableDownloadOptions options, BlobRange range, Integer blockSize, BlobAccessConditions accessConditions, boolean rangeGetContentMD5, Duration timeout) throws IOException {
        Mono<Void> download = this.blobAsyncClient.downloadToFile(filePath, range, blockSize, accessConditions, rangeGetContentMD5, options);
        try {
            if (timeout == null) {
                download.block();
            } else {
                download.block(timeout);
            }
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }

    public VoidResponse delete() {
        return this.delete(null, null, null);
    }

    public VoidResponse delete(DeleteSnapshotsOptionType deleteBlobSnapshotOptions, BlobAccessConditions accessConditions, Duration timeout) {
        Mono<VoidResponse> response = this.blobAsyncClient.delete(deleteBlobSnapshotOptions, accessConditions);
        return Utility.blockWithOptionalTimeout(response, timeout);
    }

    public Response<BlobProperties> getProperties() {
        return this.getProperties(null, null);
    }

    public Response<BlobProperties> getProperties(BlobAccessConditions accessConditions, Duration timeout) {
        Mono<Response<BlobProperties>> response = this.blobAsyncClient.getProperties(accessConditions);
        return Utility.blockWithOptionalTimeout(response, timeout);
    }

    public VoidResponse setHTTPHeaders(BlobHTTPHeaders headers) {
        return this.setHTTPHeaders(headers, null, null);
    }

    public VoidResponse setHTTPHeaders(BlobHTTPHeaders headers, BlobAccessConditions accessConditions, Duration timeout) {
        Mono<VoidResponse> response = this.blobAsyncClient.setHTTPHeaders(headers, accessConditions);
        return Utility.blockWithOptionalTimeout(response, timeout);
    }

    public VoidResponse setMetadata(Metadata metadata) {
        return this.setMetadata(metadata, null, null);
    }

    public VoidResponse setMetadata(Metadata metadata, BlobAccessConditions accessConditions, Duration timeout) {
        Mono<VoidResponse> response = this.blobAsyncClient.setMetadata(metadata, accessConditions);
        return Utility.blockWithOptionalTimeout(response, timeout);
    }

    public Response<String> createSnapshot() {
        return this.createSnapshot(null, null, null);
    }

    public Response<String> createSnapshot(Metadata metadata, BlobAccessConditions accessConditions, Duration timeout) {
        Mono<Response<String>> response = this.blobAsyncClient.createSnapshot(metadata, accessConditions);
        return Utility.blockWithOptionalTimeout(response, timeout);
    }

    public VoidResponse setTier(AccessTier tier) {
        return this.setTier(tier, null, null);
    }

    public VoidResponse setTier(AccessTier tier, LeaseAccessConditions leaseAccessConditions, Duration timeout) {
        Mono<VoidResponse> response = this.blobAsyncClient.setTier(tier, leaseAccessConditions);
        return Utility.blockWithOptionalTimeout(response, timeout);
    }

    public VoidResponse undelete() {
        return this.undelete(null);
    }

    public VoidResponse undelete(Duration timeout) {
        Mono<VoidResponse> response = this.blobAsyncClient.undelete();
        return Utility.blockWithOptionalTimeout(response, timeout);
    }

    public Response<String> acquireLease(String proposedId, int duration) {
        return this.acquireLease(proposedId, duration, null, null);
    }

    public Response<String> acquireLease(String proposedID, int duration, ModifiedAccessConditions modifiedAccessConditions, Duration timeout) {
        Mono<Response<String>> response = this.blobAsyncClient.acquireLease(proposedID, duration, modifiedAccessConditions);
        return Utility.blockWithOptionalTimeout(response, timeout);
    }

    public Response<String> renewLease(String leaseID) {
        return this.renewLease(leaseID, null, null);
    }

    public Response<String> renewLease(String leaseID, ModifiedAccessConditions modifiedAccessConditions, Duration timeout) {
        Mono<Response<String>> response = this.blobAsyncClient.renewLease(leaseID, modifiedAccessConditions);
        return Utility.blockWithOptionalTimeout(response, timeout);
    }

    public VoidResponse releaseLease(String leaseID) {
        return this.releaseLease(leaseID, null, null);
    }

    public VoidResponse releaseLease(String leaseID, ModifiedAccessConditions modifiedAccessConditions, Duration timeout) {
        Mono<VoidResponse> response = this.blobAsyncClient.releaseLease(leaseID, modifiedAccessConditions);
        return Utility.blockWithOptionalTimeout(response, timeout);
    }

    public Response<Integer> breakLease() {
        return this.breakLease(null, null, null);
    }

    public Response<Integer> breakLease(Integer breakPeriodInSeconds, ModifiedAccessConditions modifiedAccessConditions, Duration timeout) {
        Mono<Response<Integer>> response = this.blobAsyncClient.breakLease(breakPeriodInSeconds, modifiedAccessConditions);
        return Utility.blockWithOptionalTimeout(response, timeout);
    }

    public Response<String> changeLease(String leaseId, String proposedID) {
        return this.changeLease(leaseId, proposedID, null, null);
    }

    public Response<String> changeLease(String leaseId, String proposedID, ModifiedAccessConditions modifiedAccessConditions, Duration timeout) {
        Mono<Response<String>> response = this.blobAsyncClient.changeLease(leaseId, proposedID, modifiedAccessConditions);
        return Utility.blockWithOptionalTimeout(response, timeout);
    }

    public Response<StorageAccountInfo> getAccountInfo() {
        return this.getAccountInfo(null);
    }

    public Response<StorageAccountInfo> getAccountInfo(Duration timeout) {
        Mono<Response<StorageAccountInfo>> response = this.blobAsyncClient.getAccountInfo();
        return Utility.blockWithOptionalTimeout(response, timeout);
    }
}

