/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob;

import com.azure.core.http.rest.Response;
import com.azure.storage.blob.BlobAsyncClient;
import com.azure.storage.blob.BlobProperties;
import com.azure.storage.blob.StorageException;
import com.azure.storage.blob.models.BlobAccessConditions;
import com.azure.storage.blob.models.BlobRange;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import reactor.netty.ByteBufFlux;

public final class BlobInputStream
extends InputStream {
    private final BlobAsyncClient blobClient;
    private volatile boolean streamFaulted;
    private IOException lastError;
    private long streamLength;
    private final int readSize;
    private ByteBuffer currentBuffer;
    private long markedPosition;
    private int markExpiry;
    private long currentAbsoluteReadPosition;
    private long bufferStartOffset;
    private int bufferSize;
    private BlobAccessConditions accessCondition = null;
    private final long blobRangeOffset;

    BlobInputStream(BlobAsyncClient blobClient, BlobAccessConditions accessCondition) throws StorageException {
        this(blobClient, 0L, null, accessCondition);
    }

    BlobInputStream(BlobAsyncClient blobClient, long blobRangeOffset, Long blobRangeLength, BlobAccessConditions accessCondition) throws StorageException {
        this.blobRangeOffset = blobRangeOffset;
        this.blobClient = blobClient;
        this.streamFaulted = false;
        this.currentAbsoluteReadPosition = blobRangeOffset;
        this.readSize = 0x400000;
        if (blobRangeOffset < 0L || blobRangeLength != null && blobRangeLength <= 0L) {
            throw new IndexOutOfBoundsException();
        }
        BlobProperties properties = (BlobProperties)((Response)blobClient.getProperties().block()).value();
        this.streamLength = blobRangeLength == null ? properties.blobSize() - this.blobRangeOffset : Math.min(properties.blobSize() - this.blobRangeOffset, blobRangeLength);
        this.reposition(blobRangeOffset);
    }

    @Override
    public synchronized int available() throws IOException {
        return this.bufferSize - (int)(this.currentAbsoluteReadPosition - this.bufferStartOffset);
    }

    private synchronized void checkStreamState() throws IOException {
        if (this.streamFaulted) {
            throw this.lastError;
        }
    }

    @Override
    public synchronized void close() throws IOException {
        this.currentBuffer = null;
        this.streamFaulted = true;
        this.lastError = new IOException("Stream is already closed.");
    }

    private synchronized void dispatchRead(int readLength) throws IOException {
        try {
            this.currentBuffer = (ByteBuffer)this.blobClient.blobAsyncRawClient.download(new BlobRange(this.currentAbsoluteReadPosition, readLength), this.accessCondition, false).flatMap(res -> ByteBufFlux.fromInbound(res.body(null)).aggregate().asByteBuffer()).block();
            this.bufferSize = readLength;
            this.bufferStartOffset = this.currentAbsoluteReadPosition;
        }
        catch (StorageException e) {
            this.streamFaulted = true;
            this.lastError = new IOException((Throwable)((Object)e));
            throw this.lastError;
        }
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.markedPosition = this.currentAbsoluteReadPosition;
        this.markExpiry = readlimit;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public int read() throws IOException {
        byte[] tBuff = new byte[1];
        int numberOfBytesRead = this.read(tBuff, 0, 1);
        if (numberOfBytesRead > 0) {
            return tBuff[0] & 0xFF;
        }
        if (numberOfBytesRead == 0) {
            throw new IOException("Unexpected error. Stream returned unexpected number of bytes.");
        }
        return -1;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        return this.readInternal(b, off, len);
    }

    private synchronized int readInternal(byte[] b, int off, int len) throws IOException {
        int numberOfBytesRead;
        this.checkStreamState();
        if ((this.currentBuffer == null || this.currentBuffer.remaining() == 0) && this.currentAbsoluteReadPosition < this.streamLength + this.blobRangeOffset) {
            this.dispatchRead((int)Math.min((long)this.readSize, this.streamLength + this.blobRangeOffset - this.currentAbsoluteReadPosition));
        }
        len = Math.min(len, this.readSize);
        if (this.currentBuffer.remaining() == 0) {
            numberOfBytesRead = -1;
        } else {
            numberOfBytesRead = Math.min(len, this.currentBuffer.remaining());
            this.currentBuffer = this.currentBuffer.get(b, off, numberOfBytesRead);
        }
        if (numberOfBytesRead > 0) {
            this.currentAbsoluteReadPosition += (long)numberOfBytesRead;
        }
        if (this.markExpiry > 0 && this.markedPosition + (long)this.markExpiry < this.currentAbsoluteReadPosition) {
            this.markedPosition = this.blobRangeOffset;
            this.markExpiry = 0;
        }
        return numberOfBytesRead;
    }

    private synchronized void reposition(long absolutePosition) {
        this.currentAbsoluteReadPosition = absolutePosition;
        this.currentBuffer = ByteBuffer.allocate(0);
        this.bufferStartOffset = absolutePosition;
    }

    @Override
    public synchronized void reset() throws IOException {
        if (this.markedPosition + (long)this.markExpiry < this.currentAbsoluteReadPosition) {
            throw new IOException("Stream mark expired.");
        }
        this.reposition(this.markedPosition);
    }

    @Override
    public synchronized long skip(long n) throws IOException {
        if (n == 0L) {
            return 0L;
        }
        if (n < 0L || this.currentAbsoluteReadPosition + n > this.streamLength + this.blobRangeOffset) {
            throw new IndexOutOfBoundsException();
        }
        this.reposition(this.currentAbsoluteReadPosition + n);
        return n;
    }
}

