/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob;

import com.azure.core.http.rest.Response;
import com.azure.storage.blob.AppendBlobAsyncClient;
import com.azure.storage.blob.BlobAsyncClient;
import com.azure.storage.blob.BlobProperties;
import com.azure.storage.blob.BlockBlobAsyncClient;
import com.azure.storage.blob.PageBlobAsyncClient;
import com.azure.storage.blob.StorageException;
import com.azure.storage.blob.models.AppendBlobAccessConditions;
import com.azure.storage.blob.models.AppendPositionAccessConditions;
import com.azure.storage.blob.models.BlobAccessConditions;
import com.azure.storage.blob.models.BlobType;
import com.azure.storage.blob.models.LeaseAccessConditions;
import com.azure.storage.blob.models.PageBlobAccessConditions;
import com.azure.storage.blob.models.PageRange;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.CompletionHandler;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Operators;

public class BlobOutputStream
extends OutputStream {
    private BlobAccessConditions accessCondition;
    private AppendPositionAccessConditions appendPositionAccessConditions;
    private String blockIdPrefix;
    private TreeMap<Long, String> blockList;
    private int internalWriteThreshold = -1;
    private volatile IOException lastError = null;
    private long initialBlobOffset;
    private final BlobAsyncClient blobClient;
    private BlobType streamType = BlobType.BLOCK_BLOB;

    private BlobOutputStream(BlobAsyncClient parentBlob) throws StorageException {
        this.blobClient = parentBlob;
    }

    BlobOutputStream(BlockBlobAsyncClient parentBlob, BlobAccessConditions accessCondition) throws StorageException {
        this(parentBlob);
        this.accessCondition = accessCondition;
        this.blockList = new TreeMap();
        this.blockIdPrefix = String.valueOf(UUID.randomUUID().toString()) + "-";
        this.streamType = BlobType.BLOCK_BLOB;
        this.internalWriteThreshold = 0x400000;
    }

    BlobOutputStream(PageBlobAsyncClient parentBlob, long length, BlobAccessConditions accessCondition) throws StorageException {
        this(parentBlob);
        this.streamType = BlobType.PAGE_BLOB;
        this.accessCondition = accessCondition;
        this.internalWriteThreshold = (int)Math.min(0x400000L, length);
    }

    BlobOutputStream(AppendBlobAsyncClient parentBlob, AppendBlobAccessConditions accessCondition) throws StorageException {
        this(parentBlob);
        this.streamType = BlobType.APPEND_BLOB;
        this.accessCondition = new BlobAccessConditions();
        if (accessCondition != null) {
            this.appendPositionAccessConditions = accessCondition.appendPositionAccessConditions();
            this.accessCondition = new BlobAccessConditions().modifiedAccessConditions(accessCondition.modifiedAccessConditions()).leaseAccessConditions(accessCondition.leaseAccessConditions());
            this.initialBlobOffset = accessCondition.appendPositionAccessConditions().appendPosition() != null ? accessCondition.appendPositionAccessConditions().appendPosition().longValue() : ((BlobProperties)((Response)parentBlob.getProperties().block()).value()).blobSize();
        }
        this.internalWriteThreshold = 0x400000;
    }

    private void checkStreamState() throws IOException {
        if (this.lastError != null) {
            throw this.lastError;
        }
    }

    @Override
    public synchronized void close() throws IOException {
        try {
            this.checkStreamState();
            this.flush();
            try {
                this.commit();
            }
            catch (StorageException e) {
                throw new IOException((Throwable)((Object)e));
            }
        }
        finally {
            this.lastError = new IOException("Stream is already closed.");
        }
    }

    private synchronized void commit() throws StorageException {
        if (this.streamType == BlobType.BLOCK_BLOB) {
            BlockBlobAsyncClient blobRef = (BlockBlobAsyncClient)this.blobClient;
            blobRef.commitBlockList(new ArrayList<String>(this.blockList.values()), null, null, this.accessCondition).block();
        }
    }

    private Mono<Integer> dispatchWrite(Flux<ByteBuf> bufferRef, int writeLength, long offset) {
        if (writeLength == 0) {
            return Mono.empty();
        }
        if (this.streamType == BlobType.PAGE_BLOB && writeLength % 512 != 0) {
            return Mono.error((Throwable)new IOException(String.format("Page data must be a multiple of 512 bytes. Buffer currently contains %d bytes.", writeLength)));
        }
        if (this.streamType == BlobType.BLOCK_BLOB) {
            String blockID = this.getCurrentBlockId();
            this.blockList.put(offset, blockID);
            return this.writeBlock(bufferRef, blockID, writeLength).then(Mono.just((Object)writeLength));
        }
        if (this.streamType == BlobType.PAGE_BLOB) {
            return this.writePages(bufferRef, offset, writeLength).then(Mono.just((Object)writeLength));
        }
        if (this.streamType == BlobType.APPEND_BLOB) {
            if (this.appendPositionAccessConditions != null && this.appendPositionAccessConditions.maxSize() != null && this.initialBlobOffset > this.appendPositionAccessConditions.maxSize()) {
                this.lastError = new IOException("Block data should not exceed BlockBlobURL.MAX_STAGE_BLOCK_BYTES");
                return Mono.error((Throwable)this.lastError);
            }
            return this.appendBlock(bufferRef, offset, writeLength).then(Mono.justOrEmpty((Object)writeLength));
        }
        return Mono.error((Throwable)new RuntimeException("Unknown blob type " + (Object)((Object)this.streamType)));
    }

    private Mono<Void> writeBlock(Flux<ByteBuf> blockData, String blockId, long writeLength) {
        BlockBlobAsyncClient blobRef = (BlockBlobAsyncClient)this.blobClient;
        LeaseAccessConditions leaseAccessConditions = this.accessCondition == null ? null : this.accessCondition.leaseAccessConditions();
        return blobRef.stageBlock(blockId, blockData, writeLength, leaseAccessConditions).then().onErrorResume(t -> t instanceof StorageException, e -> {
            this.lastError = new IOException((Throwable)e);
            return null;
        });
    }

    private Mono<Void> writePages(Flux<ByteBuf> pageData, long offset, long writeLength) {
        PageBlobAsyncClient blobRef = (PageBlobAsyncClient)this.blobClient;
        PageBlobAccessConditions pageBlobAccessConditions = this.accessCondition == null ? null : new PageBlobAccessConditions().leaseAccessConditions(this.accessCondition.leaseAccessConditions()).modifiedAccessConditions(this.accessCondition.modifiedAccessConditions());
        return blobRef.pageBlobAsyncRawClient.uploadPages(new PageRange().start(offset).end(offset + writeLength - 1L), pageData, pageBlobAccessConditions).then().onErrorResume(t -> t instanceof StorageException, e -> {
            this.lastError = new IOException((Throwable)e);
            return null;
        });
    }

    private Mono<Void> appendBlock(Flux<ByteBuf> blockData, long offset, long writeLength) {
        AppendBlobAsyncClient blobRef = (AppendBlobAsyncClient)this.blobClient;
        if (this.appendPositionAccessConditions == null) {
            this.appendPositionAccessConditions = new AppendPositionAccessConditions();
        }
        this.appendPositionAccessConditions.appendPosition(offset);
        AppendBlobAccessConditions appendBlobAccessConditions = this.accessCondition == null ? null : new AppendBlobAccessConditions().leaseAccessConditions(this.accessCondition.leaseAccessConditions()).modifiedAccessConditions(this.accessCondition.modifiedAccessConditions());
        return blobRef.appendBlobAsyncRawClient.appendBlock(blockData, writeLength, appendBlobAccessConditions).then().onErrorResume(t -> t instanceof IOException || t instanceof StorageException, e -> {
            this.lastError = new IOException((Throwable)e);
            return null;
        });
    }

    @Override
    public void flush() throws IOException {
        this.checkStreamState();
    }

    private String getCurrentBlockId() {
        String blockIdSuffix = String.format("%06d", this.blockList.size());
        byte[] blockIdInBytes = (String.valueOf(this.blockIdPrefix) + blockIdSuffix).getBytes(StandardCharsets.UTF_8);
        return Base64.getEncoder().encodeToString(blockIdInBytes);
    }

    @Override
    public void write(byte[] data) throws IOException {
        this.write(data, 0, data.length);
    }

    @Override
    public void write(byte[] data, int offset, int length) throws IOException {
        if (offset < 0 || length < 0 || length > data.length - offset) {
            throw new IndexOutOfBoundsException();
        }
        this.writeInternal(data, offset, length);
    }

    @Override
    public void write(int byteVal) throws IOException {
        this.write(new byte[]{(byte)(byteVal & 0xFF)});
    }

    private void writeInternal(byte[] data, int offset, int length) {
        int chunks = (int)Math.ceil((double)length / (double)this.internalWriteThreshold);
        Flux chunkPositions = Flux.range((int)0, (int)chunks).map(c -> offset + c * this.internalWriteThreshold);
        if (this.streamType == BlobType.APPEND_BLOB) {
            chunkPositions.concatMap(pos -> this.processChunk(data, (int)pos, offset, length)).then().block();
        } else {
            chunkPositions.concatMap(pos -> this.processChunk(data, (int)pos, offset, length)).then().block();
        }
    }

    private Mono<Integer> processChunk(byte[] data, int position, int offset, int length) {
        int chunkLength = this.internalWriteThreshold;
        if (position + chunkLength > offset + length) {
            chunkLength = offset + length - position;
        }
        ByteBufStreamFromByteArray chunkData = new ByteBufStreamFromByteArray(data, 65536, position, chunkLength);
        return this.dispatchWrite(chunkData, chunkLength, position - offset).doOnError(t -> {
            this.lastError = t instanceof IOException ? (IOException)t : new IOException((Throwable)t);
        });
    }

    private static final class ByteBufStreamFromByteArray
    extends Flux<ByteBuf> {
        private final ByteBufAllocator alloc = ByteBufAllocator.DEFAULT;
        private final byte[] bigByteArray;
        private final int chunkSize;
        private final int offset;
        private final int length;

        ByteBufStreamFromByteArray(byte[] bigByteArray, int chunkSize, int offset, int length) {
            this.bigByteArray = bigByteArray;
            this.chunkSize = chunkSize;
            this.offset = offset;
            this.length = length;
        }

        public void subscribe(CoreSubscriber<? super ByteBuf> actual) {
            FileReadSubscription subscription = new FileReadSubscription((Subscriber<? super ByteBuf>)actual, this.bigByteArray, this.alloc, this.chunkSize, this.offset, this.length);
            actual.onSubscribe((Subscription)subscription);
        }

        static final class FileReadSubscription
        implements Subscription,
        CompletionHandler<Integer, ByteBuf> {
            private static final int NOT_SET = -1;
            private static final long serialVersionUID = -6831808726875304256L;
            private final Subscriber<? super ByteBuf> subscriber;
            private volatile int position;
            private final byte[] bigByteArray;
            private final ByteBufAllocator alloc;
            private final int chunkSize;
            private final int offset;
            private final int length;
            private volatile boolean done;
            private Throwable error;
            private volatile ByteBuf next;
            private volatile boolean cancelled;
            volatile int wip;
            static final AtomicIntegerFieldUpdater<FileReadSubscription> WIP = AtomicIntegerFieldUpdater.newUpdater(FileReadSubscription.class, "wip");
            volatile long requested;
            static final AtomicLongFieldUpdater<FileReadSubscription> REQUESTED = AtomicLongFieldUpdater.newUpdater(FileReadSubscription.class, "requested");

            FileReadSubscription(Subscriber<? super ByteBuf> subscriber, byte[] bigByteArray, ByteBufAllocator alloc, int chunkSize, int offset, int length) {
                this.subscriber = subscriber;
                this.bigByteArray = bigByteArray;
                this.alloc = alloc;
                this.chunkSize = chunkSize;
                this.offset = offset;
                this.length = length;
                this.position = -1;
            }

            public void request(long n) {
                if (Operators.validate((long)n)) {
                    Operators.addCap(REQUESTED, (Object)this, (long)n);
                    this.drain();
                }
            }

            public void cancel() {
                this.cancelled = true;
            }

            @Override
            public void completed(Integer bytesRead, ByteBuf buffer) {
                if (!this.cancelled) {
                    if (bytesRead == -1) {
                        this.done = true;
                    } else {
                        int position2;
                        int pos = this.position;
                        int bytesWanted = Math.min(bytesRead, this.maxRequired(pos));
                        buffer.writerIndex(bytesWanted);
                        this.position = position2 = pos + bytesWanted;
                        this.next = buffer;
                        if (position2 >= this.offset + this.length) {
                            this.done = true;
                        }
                    }
                    this.drain();
                }
            }

            @Override
            public void failed(Throwable exc, ByteBuf attachment) {
                if (!this.cancelled) {
                    this.error = exc;
                    this.done = true;
                    this.drain();
                }
            }

            private void drain() {
                if (WIP.getAndIncrement(this) != 0) {
                    return;
                }
                if (this.position == -1) {
                    this.position = this.offset;
                    this.doRead();
                }
                int missed = 1;
                do {
                    if (this.cancelled) {
                        return;
                    }
                    if (REQUESTED.get(this) <= 0L) continue;
                    boolean emitted = false;
                    boolean d = this.done;
                    ByteBuf bb = this.next;
                    if (bb != null) {
                        this.next = null;
                        this.subscriber.onNext((Object)bb);
                        emitted = true;
                    } else {
                        emitted = false;
                    }
                    if (d) {
                        if (this.error != null) {
                            this.subscriber.onError(this.error);
                            return;
                        }
                        this.subscriber.onComplete();
                        return;
                    }
                    if (!emitted) continue;
                    Operators.produced(REQUESTED, (Object)this, (long)1L);
                    this.doRead();
                } while ((missed = WIP.addAndGet(this, -missed)) != 0);
            }

            private void doRead() {
                int pos = this.position;
                int readSize = Math.min(this.chunkSize, this.maxRequired(pos));
                ByteBuf innerBuf = this.alloc.buffer(readSize, readSize);
                try {
                    innerBuf.writeBytes(this.bigByteArray, pos, readSize);
                    this.completed(readSize, innerBuf);
                }
                catch (Exception e) {
                    this.failed((Throwable)e, innerBuf);
                }
            }

            private int maxRequired(long pos) {
                long maxRequired = (long)(this.offset + this.length) - pos;
                if (maxRequired <= 0L) {
                    return 0;
                }
                int m = (int)maxRequired;
                if (m < 0) {
                    return Integer.MAX_VALUE;
                }
                return m;
            }
        }
    }
}

